(function($, exports) {
    console.debug("tweets script", exports);

    var x = /^https?:\/\/(?:(?:(?:m(?:obile)?)|(?:www)|)\.)?x\.com/,
        P = /\/@?([_\w\d]+)\/status(?:es)?\/([\d]+)\/?/,
        R = new RegExp("" + x.source + P.source)

    function parsePermalinkUrl(e) {
        console.debug("[Twitter parsePermalinkUrl]", e)
        var t = e && e.match(R);
        if (t && t.length === 3) {
            console.debug("[Twitter parsePermalinkUrl] match ",e, t)
            return {
                screenName: t[1],
                statusId: t[2]
            }
        }
    }
    exports.TweetsDB = (function() {
        var _ = {
            tweets: {},
            pictures: [],
            picturesByTweetID: {},
            picturesByPath: {},
            videos: [],
            videosByTweetID: {},
            tweetsAtPath: {},
        };

        _.indexTweet = function(t, page, users) {
            console.debug("[Twitter indexTweet]", t, page, users)
            if (t == undefined) {
                console.error("indexTweet undefined", t, page, users)
                return;
            }
            var path = document.location.pathname
            try {
                var user = users[t.user_id_str]
                t.fas_user = {
                    id_str: user.id_str,
                    name: user.name,
                    screen_name: user.screen_name,
                    profile_pic: user.profile_image_url_https
                }
                _.tweets[t.id_str] = t;
                var tap = _.tweetsAtPath[path] || []
                tap.push(t.id_str)
                _.tweetsAtPath[path] = tap;
                _.detectMedias(t);
            } catch (ex) {
                console.error("Error indexing", ex, t)
            }
        };

        _.markTweetAsSponsored = function (tweetID) {
            const originTweet = _.tweets[tweetID];
            if (!originTweet) return;

            try {
                console.debug("[TWAD] tweet", originTweet);
                originTweet.fas_sponsored = true;
                const tweetIDStr         = originTweet.id_str;
                const tweetBody          = originTweet.full_text;
                const advertiserName     = originTweet.fas_user?.screen_name || "";
                const advertiserFullName = originTweet.fas_user?.name        || "";
                let advertiserAvatarURL  = originTweet.fas_user?.avatarURL
                                        || originTweet.fas_user?.profile_image_url_https
                                        || "";
                advertiserAvatarURL = advertiserAvatarURL.replace(/_normal(\.\w+)$/, "$1");
                const url = `https://x.com/${advertiserName}/status/${tweetIDStr}`;

                const ads = [{
                    visible   : true,
                    body      : tweetBody,
                    source    : advertiserName,
                    name      : advertiserFullName,
                    avatar_url: advertiserAvatarURL,
                    url       : url
                }];

                if (ads.length > 0) {
                    const adJson = JSON.stringify({ 0: ads, 1: "", 2: "JS_101", 3: "twitter" });
                    console.debug("[AD]", adJson);
                    _fas_.logTwitterAdGroup_json(adJson);
                    window._fas_checkCompletedProcesses("ad_detection");
                }
            } catch (ex) {
                console.error("[Twitter markTweetAsSponsored]", originTweet, tweetID, ex);
            }
        };


        _.detectMedias = function(tweet) {
            var tweetID = tweet.id_str;
            var medias = tweet.getValueForKeyPath("extended_entities.media")
            if (medias !== undefined) {
                var videos = []
                var pictures = []
                var index = 1
                medias.forEach(function(media) {
                    if (media.media_url_https !== undefined) {
                        media.thumb_url = media.media_url_https.replace(/\.(jpg|gif|png)$/, "");
                    }
                    if (media.video_info !== undefined && media.video_info.variants !== undefined) {
                        var variantVideos = media.video_info.variants
                        variantVideos = variantVideos.filter(function(item) {
                            return item.bitrate !== undefined;
                        })
                        variantVideos = variantVideos.sort(function(a, b) {
                            return b.bitrate - a.bitrate;
                        })
                        media.bestQualityURL = variantVideos[0].url
                        videos.push(media)
                    } else if (media.media_url_https !== undefined) {
                        var data = parsePermalinkUrl(media.expanded_url)
                        media['permaLink'] = "/" + data.screenName + "/status/" + data.statusId + "/photo/" + index
                        media['currentPermaLink'] = "/status/" + tweet.id_str + "/photo/" + index
                        pictures.push(media)
                        _.picturesByPath["/status/" + tweet.id_str + "/photo/" + index] = media
                        index++
                    }
                })
                if (videos.length > 0) {
                    _.videos.push({
                        tweetID: tweetID,
                        videos: videos
                    })
                    _.videosByTweetID[tweetID] = videos
                }
                if (pictures.length > 0) {
                    _.pictures.push({
                        tweetID: tweetID,
                        pictures: pictures
                    })
                    _.picturesByTweetID[tweetID] = pictures
                }
            }
        }

        // Search
        _.findTweetByPathName = function(pathName, callback) {
            var found = false;
            return undefined
        }

        _.findPictureByPathName = function(pathName, callback) {
            try {
                var found = false;
                var pathData = parsePermalinkUrl("https://x.com" + pathName)
                var expectedPath = "/status/" + pathData.statusId + pathName.substring(pathName.indexOf("/photo/"))
                var pic = _.picturesByPath[expectedPath];
                if (pic && pic.media_url_https !== undefined) {
                    callback(pic)
                    found = true
                }
                return found
            } catch (ex) {
            	console.error("[Twitter findPictureByPathName]", ex)
                return false
            }
        };

        _.findVideoByPathName = function(pathName, callback) {
            var found = false;
            _.videos.forEach(function(tweet) {
                if (found) {
                    return
                }
                if (tweet.videos == undefined) {
                    return
                }
                tweet.videos.forEach(function(video) {
                    if (video.expanded_url.indexOf(pathName) !== -1 &&
                        video.bestQualityURL !== undefined) {
                        callback(video)
                        found = true
                    }
                })
            })
            return found
        };

        _.findVideoByTweetID = function(tweetID, callback) {
            var found = false;
            _.videos.forEach(function(video) {
                if (found) {
                    return
                }
                if (video.tweetID == tweetID) {
                    found = true
                    callback(video.videos[0])
                }
            })
            return found
        }

        _.findTweetByMediaURL = function(mediaURL, callback) {
            var found = false;
            for (var tid in _.tweets) {
                if (found) {
                    break
                }
                if (_.tweets.hasOwnProperty(tid)) {
                    var tweet = _.tweets[tid]
                    var medias = tweet.getValueForKeyPath("extended_entities.media")
                    if (medias !== undefined) {
                        medias.forEach(function(media) {
                            if (mediaURL.indexOf(media.thumb_url) == 0) {
                                callback(tweet, media)
                                found = true
                            }
                        });
                    }
                }
            }
            return found
        }

        _.inspectedMedias = function() {
            var path = document.location.pathname
            var tweetIDs = _.tweetsAtPath[path] || []
            var medias = []
            tweetIDs.forEach(function(tid) {
                var videos = _.videosByTweetID[tid] || []
                videos.forEach(function(video) {
                    medias.push({
                        type: "video",
                        thumbnailURL: video.thumb_url + "?format=jpg&name=small",
                        previewURL: video.bestQualityURL,
                        originalURL: video.bestQualityURL,
                        metadatas: {
                            inspector: "generic"
                        }
                    })
                })
                var pictures = _.picturesByTweetID[tid] || []
                pictures.forEach(function(photo) {
                    medias.push({
                        type: "photo",
                        thumbnailURL: photo.thumb_url + "?format=jpg&name=small",
                        previewURL: photo.thumb_url + "?format=jpg&name=small",
                        originalURL: photo.thumb_url + "?format=jpg&name=large",
                        metadatas: {
                            inspector: "generic"
                        }
                    })
                })
            })
            return medias
        }
        return _;
    })();
})