(function($,exports){

        console.debug("twitter preload ...")

        var x = /^https?:\/\/(?:(?:(?:m(?:obile)?)|(?:www)|)\.)?x\.com/,
        P = /\/@?([_\w\d]+)\/status(?:es)?\/([\d]+)\/?/,
        R = new RegExp("" + x.source + P.source)

        if (window._fas_tweetVideos === undefined) {
            window._fas_tweetVideos = []
        }

        if (window._fas_tweetPictures === undefined) {
            window._fas_tweetPictures = []
        }

        window._fas_latestPathNameTested = ""
        window._fas_latestPathNameTestedPicture = ""

        window._fas_completedProcesses = {}
        window._fas_checkCompletedProcesses = (function() {
            return window._fas_completedProcesses['ad_detection'] === true
                   && window._fas_completedProcesses['badge_detection'] === true
        })

        window._fas_processCompleted = (function(name) {
            window._fas_completedProcesses[name] = true
            if (window._fas_checkCompletedProcesses()) {
                window._fas_closeService()
            }
        })

        window._fas_closeService = (function() {
            if ("_close_" in window) {
                _close_.destroy()
            }
        })

        function hasPromotedMetadata (itemContent, tweetPathBase) {
            return  itemContent.getValueForKeyPath("promotedMetadata")                           ||
                    itemContent.getValueForKeyPath(`${tweetPathBase}.legacy.promoted_metadata`)  ||
                    itemContent.getValueForKeyPath(`${tweetPathBase}.legacy.promotedMetadata`);
        }

        function parsePermalinkUrl(e) {
            e = e.replace(/twitter\.com\//, "x.com/");
            var t = e && e.match(R);
            if (t && t.length === 3) {
                return {
                    screenName: t[1],
                    statusId: t[2]
                }
            }
        }

        function getUserPropertyFromID(users, advertiserID, property) {
            if (users !== undefined) {
                for (var userID in users) {
                    if (users.hasOwnProperty(userID)) {
                        var user = users[userID]
                        console.debug('getUserPropertyFromID  users[userID]',  users[userID])
                        if (user['id_str'] === advertiserID) {
                            return user[property]
                        }
                    }
                }
            }
            return advertiserID
        }

        var instructionsMap = {
            "timeline": {
                getter: function (json) { return json.getValueForKeyPath("data.home.home_timeline_urt.instructions")},
                setter: function (json, newInstructions) {
                    var newJSON = json
                    var data = json.data
                    var home = data.home
                    var home_timeline_urt = home.home_timeline_urt
                    home_timeline_urt.instructions = newInstructions
                    home.home_timeline_urt = home_timeline_urt
                    data.home = home
                    newJSON.data = data
                    return newJSON
                }
            },
            "user": {
                getter: function (json) { return json.getValueForKeyPath("data.user.result.timeline_v2.timeline.instructions")},
                setter: function (json, newInstructions) {
                    var newJSON = json
                    var data = json.data
                    var user = data.user
                    var result = user.result
                    var timeline_v2 = result.timeline_v2
                    var timeline = timeline_v2.timeline
                    timeline.instructions = newInstructions
                    timeline_v2.timeline = timeline
                    result.timeline_v2 = timeline_v2
                    user.result = result
                    data.user = user
                    newJSON.data = data
                    // console.debug("[instructions][user] setter", json, newInstructions, newJSON)
                    return newJSON
                }
            },
            "search": {
                getter: function (json) { return json.getValueForKeyPath("data.search_by_raw_query.search_timeline.timeline.instructions")},
                setter: function (json, newInstructions) {
                    var newJSON = json
                    var data = json.data
                    var search_by_raw_query = data.search_by_raw_query
                    var search_timeline = search_by_raw_query.search_timeline
                    var timeline = search_timeline.timeline
                    timeline.instructions = newInstructions
                    search_timeline.timeline = timeline
                    search_by_raw_query.search_timeline = search_timeline
                    data.search_by_raw_query = search_by_raw_query
                    newJSON.data = data
                    return newJSON
                }
            },
            "thread": {
                getter: function (json) { return json.getValueForKeyPath("data.threaded_conversation_with_injections_v2.instructions")},
                setter: function (json, newInstructions) {
                    var newJSON = json
                    var data = json.data
                    var threaded_conversation_with_injections_v2 = data.threaded_conversation_with_injections_v2
                    threaded_conversation_with_injections_v2.instructions = newInstructions
                    data.threaded_conversation_with_injections_v2 = threaded_conversation_with_injections_v2
                    newJSON.data = data
                    return newJSON
                }
            }
        }
        function selectInstructionBinder(json) {
            for (var key in instructionsMap) {
                var instructions = instructionsMap[key].getter(json)
                if (instructions !== undefined) {
                    return instructionsMap[key]
                }
            }
        }
        function collectUserData(user_results_result) {
            var legacyData = user_results_result["legacy"]
            // if we have a "core" object, we need to add its keys to the legacyData
            if (user_results_result["core"] !== undefined) {
                var coreData = user_results_result["core"]
                for (var key in coreData) {
                    if (coreData.hasOwnProperty(key)) {
                        legacyData[key] = coreData[key]
                    }
                }
            }
            return legacyData
        }
        function parsingAds(json, originURL) {
        	var instructionsBinder = selectInstructionBinder(json)
        	if (instructionsBinder === undefined) {
                return
            }
            var instructions = instructionsBinder.getter(json)
            if (instructions === undefined) {
                return
            }
            var newInstructions = []

            instructions.forEach(function (instruction) {
                if (instruction.entries === undefined) {
                    return
                }

                var entries = instruction.entries
                var newEntries = []

                entries.forEach(function (entry) {
                    try {
                        console.debug("[instructions] entry", entry)
                        var itemContent = entry.getValueForKeyPath("content.itemContent") || entry.getValueForKeyPath("item.itemContent")
                        if (itemContent !== undefined) {
                            var path = "tweet_results.result"
                            var tweet = itemContent.getValueForKeyPath("tweet_results.result.legacy")
                            if (!tweet) {
                                path = "tweet_results.result.tweet"
                                tweet = itemContent.getValueForKeyPath("tweet_results.result.tweet.legacy")
                            }
                            if (!tweet) {
                                console.debug("[x][instructions] no tweet found", itemContent)
                                newEntries.push(entry)
                                return
                            }
                            parsingMediaFromTweet(tweet)
                            var promotedMetadata =  entry.getValueForKeyPath("content.promotedMetadata") || hasPromotedMetadata(itemContent, path);
                            var user_id = itemContent.getValueForKeyPath(path + ".core.user_results.result.rest_id")
                            var user = collectUserData(itemContent.getValueForKeyPath(path + ".core.user_results.result"))
                            // var user = itemContent.getValueForKeyPath(path + ".core.user_results.result.legacy")
                            var users = {}
                            users[user_id] = user
                            exports.TweetsDB.indexTweet(tweet, originURL, users)
                            if (promotedMetadata && tweet !== undefined) {
                                exports.TweetsDB.markTweetAsSponsored(tweet.id_str)
                            }
                            if (!promotedMetadata || !window.OW_hasAdBlockFeature) {
                                newEntries.push(entry)
                            } else {
                                console.debug("[instructions] ad blocked", tweet)
                            }
                            try {
                                // check for retweet :
                                var retweeted_status_result = itemContent.getValueForKeyPath(path + ".legacy.retweeted_status_result")
                                if (retweeted_status_result !== undefined) {
                                    var retweeted_path = "result"
                                    var retweeted_tweet = retweeted_status_result.getValueForKeyPath("result.legacy")
                                    if (!retweeted_tweet) {
                                        retweeted_path = "result.tweet"
                                        retweeted_tweet = retweeted_status_result.getValueForKeyPath("result.tweet.legacy")
                                    }
                                    parsingMediaFromTweet(retweeted_tweet)
                                    var retweeted_user_id = retweeted_status_result.getValueForKeyPath(retweeted_path + ".core.user_results.result.rest_id")
                                    var retweeted_user = retweeted_status_result.getValueForKeyPath(retweeted_path + ".core.user_results.result.legacy")
                                    var retweeted_users = {}
                                    retweeted_users[retweeted_user_id] = retweeted_user
                                    exports.TweetsDB.indexTweet(retweeted_tweet, originURL, retweeted_users)
                                }
                            } catch (ex) { }
                        } else {
                            var items = entry.getValueForKeyPath("content.items")
                            if (items !== undefined) {
                                /*var newItems = parseEntries(items, originURL, window.OW_hasAdBlockFeature)
                                entry.content.items = newItems
                                newEntries.push(entry)*/
                            } else {
                                newEntries.push(entry)
                            }
                        }
                    } catch (ex) {
                        console.error("[FEED] entry error", ex)
                        newEntries.push(entry)
                    }
                })
                var newInstruction = instruction
                newInstruction.entries = newEntries
                newInstructions.push(newInstruction)
            })
            var newJSON = instructionsBinder.setter(json, newInstructions)
            return JSON.stringify(newJSON)
        }

        function parsingMediaFromTweet(tweet) {
            if (tweet === undefined) {
                return
            }
            try {
                if (tweet.extended_entities !== undefined
                    && tweet.extended_entities.media !== undefined) {
                    var tweetID = tweet.id_str
                    var medias = tweet.extended_entities.media
                    var videos = []
                    var pictures = []
                    var index = 1
                    medias.forEach(function (media){
                        if (media.video_info !== undefined) {
                            videos.push(media)
                        }
                        else if (media.media_url_https !== undefined) {
                            var data = parsePermalinkUrl(media.expanded_url)
                            media['permaLink'] = "/" + data.screenName + "/status/" + data.statusId + "/photo/" + index
                            pictures.push(media)
                            index++
                        }
                    })
                    if (videos.length > 0) {
                        window._fas_tweetVideos.push({tweetID:tweetID, videos:videos})
                    }
                    if (pictures.length > 0) {
                        window._fas_tweetPictures.push({tweetID:tweetID, pictures:pictures})
                    }
                }
            } catch(ex) {
                console.error("[parsingMediaFromTweet] error", ex, tweet)
            }
        }

		XMLHttpRequest.prototype.handleJSONResponse = function(json, originURL){
		    try {
		        if (json === undefined) {
                    return;
                }
		        if (originURL.indexOf("/HomeLatestTimeline") >= 0
                    || originURL.indexOf("/SearchTimeline") >= 0
                    || originURL.indexOf("/TweetDetail") >= 0
                    || originURL.indexOf("/HomeLatestTimeline") >= 0
                    || originURL.indexOf("/UserTweets") >= 0
                    || originURL.indexOf("/UserMedia") >= 0
                    || originURL.indexOf("/Likes") >= 0
                    || originURL.indexOf("/UserTweetsAndReplies") >= 0
                    || originURL.indexOf("/HomeTimeline") >= 0) {
                    return parsingAds(json, originURL)
                }

                if (originURL.indexOf("/TweetResultByRestId") >= 0) {
                    // parse the json and extract videos and pictures information, and send it to window._fas_tweetPictures and window._fas_tweetVideos
                    var newJSON = json
                    var tweet = json.getValueForKeyPath("data.tweetResult.result.legacy")
                    parsingMediaFromTweet(tweet)
                }

		        if ("_close_" in window && originURL.indexOf("/2/badge_count/badge_count.json") > 0) {
		            console.debug("TWITTER  preload originURL.indexOf ", json)
                    var dm_badge = json.dm_unread_count
                    var ntab_badge = json.ntab_unread_count
                    var total_badge = json.total_unread_count
                    _fas_.badgeNotification(dm_badge, ntab_badge, total_badge)
                    window._fas_checkCompletedProcesses('badge_detection')
                }


		    } catch (ex) {
		        console.error("error parsing response", ex)
		        return false
		    }
		};

        (function(send) {
            XMLHttpRequest.prototype.send = function () {
              var callback = this.onreadystatechange;
              this.onreadystatechange = function() {
                  if (this.handleJSONResponse != null && this.readyState == 4) {
                    try {
                        var responseType = this.getResponseHeader("Content-Type");
                        if (responseType != null && (responseType.indexOf("application/json") == 0 || responseType.indexOf("application/x-javascript") == 0)){
                            var json = this.response;
                            var prefix = "for (;;);";
                            if (json != null && json.indexOf(prefix) == 0){
                                json = json.substring(prefix.length);
                            }
                            var newResponse = this.handleJSONResponse(JSON.parse(json), this.responseURL);
                             if (newResponse) {
                                 Object.defineProperty(this, 'responseText', {
                                     writable: true
                                 });
                                 // console.debug("JSON Ajax",this.responseURL, JSON.parse(newResponse));
                                 // console.debug("overriding response text",newResponse);
                                 this.responseText = newResponse;
                             }
                        }
                    } catch(ex){
                       console.debug("error parsing response", ex);
                    }
                }
                if (callback) {
                   callback.apply(this, arguments);
                }
              }
              send.apply(this, arguments)
            }
          }(XMLHttpRequest.prototype.send));

})