(function($, exports) {

    console.debug("instagram preload ...")

    var x = /^https?:\/\/(?:(?:(?:m(?:obile)?)|(?:www)|)\.)?x\.com/,
        P = /\/@?([_\w\d]+)\/status(?:es)?\/([\d]+)\/?/,
        R = new RegExp("" + x.source + P.source)

    window._fas_completedProcesses = {}
    window._fas_checkCompletedProcesses = (function() {
        return window._fas_completedProcesses['ad_detection'] === true &&
            window._fas_completedProcesses['badge_detection'] === true
    })

    window._fas_processCompleted = (function(name) {
        window._fas_completedProcesses[name] = true
        if (window._fas_checkCompletedProcesses()) {
            window._fas_closeService()
        }
    })

    window._fas_closeService = (function() {
        if ("_close_" in window) {
            _close_.destroy()
        }
    })

    window.__additionalDataLoaded = function (__additionalDataLoaded) {
        return function (path, data) {
            if (window.OW_hideSuggestion
                && path == 'feed'
                && data.user !== undefined
                && data.user.edge_web_feed_timeline !== undefined
                && data.user.edge_web_feed_timeline.edges !== undefined) {
                var edges = data.user.edge_web_feed_timeline.edges
                edges.forEach(function (edge){
                    if (edge.node.__typename === "GraphSuggestedUserFeedUnit") edge.node.aysf = []
                })
            }
            return __additionalDataLoaded.call(window, path, data);
        };
    }(window.__additionalDataLoaded);

    function parsePermalinkUrl(e) {
        var t = e && e.match(R);
        if (t && t.length === 3) {
            return {
                screenName: t[1],
                statusId: t[2]
            }
        }
    }

    XMLHttpRequest.prototype.handleJSONResponse = function(json, originURL) {
        try {
            if (originURL.indexOf("/api/v1/feed/timeline") >= 0) {
                parseTimeline(json)
            }

            if (window.OW_hideSuggestion && originURL.indexOf("?query_hash") > 0) {
               if (json !== undefined && json.data !== undefined){
                   var user = json.data.user
                   if (user !== undefined
                       && user != null
                       && user.edge_suggested_users !== undefined) {
                       return JSON.stringify({data:{user:{edge_suggested_users:[]}}, status:'ok'})
                   }
               }
            }

           if (window.OW_hideStory && originURL.indexOf("?query_hash") > 0) {
               if (json !== undefined && json.data !== undefined){
                   var user = json.data.user
                   if (user !== undefined
                       && user.feed_reels_tray !== undefined
                       && user.feed_reels_tray.edge_reels_tray_to_reel !== undefined) {
                       var edge = user.feed_reels_tray.edge_reels_tray_to_reel
                       console.debug("story edge ",edge)
                       return JSON.stringify({data:{user:{feed_reels_tray:{edge_reels_tray_to_reel:{edges:[]}}}}, status:'ok'})
                   }
               }
            }

           if (window.OW_hideStory && originURL.indexOf("?query_hash") > 0) {
               if (json !== undefined && json.data !== undefined){
                   var reels_media = json.data.reels_media
                   if (reels_media !== undefined) {
                       console.debug("story edge bis ",edge)
                       return JSON.stringify({data:{reels_media:[]}, status:'ok'})
                   }
               }
           }

        } catch (ex) {
            console.error("error parsing response", ex)
        }
    };

    (function(open) {
        XMLHttpRequest.prototype.open = function() {
            if (arguments.length > 1) {
                this.fas_requestURL = arguments[1]
            }
            open.apply(this, arguments)
        }
    } (XMLHttpRequest.prototype.open));


    // ad detection
    function parseTimeline(timeline) {
        var feed_items = timeline && (timeline["items"] || timeline["feed_items"])
        if (!feed_items) {
            // console.debug("[IG] no feed items")
            //window.friendlyfied.plugins.AnalyticsWebPlugin.track("IGADFETCH_NOFEEDITEMS_ERROR", {})
            return null;
        }
        var items = []
        feed_items.forEach(function(item){
            // console.debug("[IG] item", item)
            try {
                if (media_or_ad = item["media_or_ad"]) {
                    if (ad_id = media_or_ad["ad_id"]) {
                        console.debug("[IG][ADITEM]", item)
                        if (adItems = media_or_ad["items"]) {
                            adItems.forEach((adItem) => {
                                if (adItem["code"] && adItem["id"]) {
                                    //exports.IGAdsRepo.add(adItem)
                                    var source = adItem["user"] && adItem["user"]["full_name"]
                                    var data = {
                                        adInbox: {
                                            owner:  source,
                                            ownerURL: "https://www.instagram.com/"+adItem["user"]["username"],
                                            avatarURL: adItem["user"]["profile_pic_url"],
                                            body: adItem["caption"] && adItem["caption"]["text"]
                                        }
                                    }
                                    items.push({
                                        visible: false,
                                        url: "https://www.instagram.com/p/"+adItem["code"],
                                        source: source,
                                        data: data
                                    })
                                }
                            })
                        }
                    }
                }
            } catch(ex) {
                console.debug("[IG] parse feed item error", ex)
            }
        })
        if (items.length > 0) {
            //var payload = { "origin": "instagram", "parser": "JS_XHR", "html": "", "ads": items}
            //console.debug("[IG] sending ads", payload)

            var adJson = JSON.stringify({0:items, 1:"", 2:"JS_010", 3:"instagram"})
            _fas_.logInstagramAdGroup_json(adJson);

            //window.friendlyfied.plugins.AdLogWebPlugin.log(payload)
            // return timeline["next_max_id"];
        } else {
            // return timeline["next_max_id"];
        }
    }

    /*(function(send) {
        XMLHttpRequest.prototype.send = function() {
            var callback = this.onreadystatechange
            var callbackURL
            this.onreadystatechange = function() {
                if (this.handleJSONResponse != null && this.readyState == 4) {
                    // var responseURL = this.responseURL
                    try {
                        var responseType = this.getResponseHeader("Content-Type");
                        callbackURL = this.responseURL
                        if (responseType != null
                            && (responseType.indexOf("application/json") == 0
                                || responseType.indexOf("application/x-javascript") == 0)){
                            var json = this.response;
                            var prefix = "for (;;);";
                            if (json != null && json !== undefined && json.indexOf(prefix) == 0) {
                                json = json.substring(prefix.length)
                            }
                            var newResponse = this.handleJSONResponse(JSON.parse(json), this.responseURL)
                            if (newResponse) {
                                Object.defineProperty(this, 'responseText', {
                                    writable: true
                                });
                                this.responseText = newResponse;
                                console.debug("newResponse", this.responseText)
                            }
                        }
                    } catch (ex) {
                        console.error("error parsing response", ex)
                    }
                }
                if (callback) {
                    callback.apply(this, arguments)
                }
            }

            if (window.OW_storyAnonymous
                && this.fas_requestURL != null
                && this.fas_requestURL !== undefined
                && this.fas_requestURL.indexOf("seen") > 0) {
                Object.defineProperty(this, 'responseText', {
                    writable: true
                });
                this.responseText = JSON.stringify({status:"ok"})
                this.readyState = 4
            } else {
                send.apply(this, arguments)
            }
        }
    }(XMLHttpRequest.prototype.send));*/


    /*var headers = {
                "Content-Type": "application/x-www-form-urlencoded",
                "Pragma": "no-cache",
                "Host": "i.instagram.com",
                "Cache-Control": "no-cache",
                "Accept-Encoding": "gzip",
                "Origin": "https://www.instagram.com",
                "User-Agent": "Instagram 123.1.0.26.115 (iPhone11,8; iOS 13_3; en_US; en-US; scale=2.00; 828x1792; 190542906)",
                "Referer": "https://www.instagram.com/",
                "X-CSRFToken": "PHv6BiSCjPh0twgNRsqw0zrL1SvvdDLH",
                "X-ASBD-ID": "198387",
                "X-IG-App-ID": "1217981644879628",
                "Priority": "u=3, i",
                "X-Instagram-AJAX": "1005611792",
                "X-IG-WWW-Claim": "hmac.AR0UTKtovWALW-cgiBycNoExsvAxsouEYDwxOFk90nRt_PzA",
    };


    var fas_timeline_req_datas = {
         "headers": headers,
         "body": {}
    }

    function parseTimeline(timeline) { // returns next_max_id if no ad found
            var feed_items = timeline && timeline["items"]
            if (!feed_items) {
                console.debug("[IG] no feed items")
                //window.friendlyfied.plugins.AnalyticsWebPlugin.track("IGADFETCH_NOFEEDITEMS_ERROR", {})
                return null;
            }
            var ads = []
            var items = []
            feed_items.forEach(function(item){
                try {
                    var code = item["code"]
                    var ad_id = item["injected"] && item["injected"]["ad_id"]
                    if (code && ad_id) {
                        ads.push(item)
                        var source = item["user"] && item["user"]["full_name"]
                        items.push({
                            visible: false,
                            url: "https://www.instagram.com/p/"+code,
                            source: source
                        })
                        //window.friendlyfied.plugins.AnalyticsWebPlugin.track("IGADFETCH_DETECTED", {source: source, code: code})
                    }
                } catch (ex) {
                    console.error("[IG] error", ex)
                }
            })
            console.debug("[IG] detected ads", ads)
            if (items.length > 0) {
                var payload = { "origin": "instagram", "parser": "JS_XHR", "html": "", "ads": items}
                console.debug("[IG] sending ads", payload)
                //window.friendlyfied.plugins.AdLogWebPlugin.log(payload)
                return timeline["next_max_id"]; // allow next page
                //return null; // never try to paginate if one ad found
            } else {
                return timeline["next_max_id"];
            }
        }
        function handleErrorResponse(error, r) {
            var event = ["IGADFETCH_ERROR_" + error.toUpperCase(),{}]
            switch (error) {
                case "noRequest":
                    break
                case "emptyBody":
                    break
                case "jsonParsing":
                    event[1] = {"desc": r["description"]}
                    break
                case "network":
                    event[1] = {"statusCode": r["statusCode"], "desc": r["description"]}
                    break
                case "missingCookie":
                    event[1] = {"cookies": r["cookies"].join(",")}
                    break
                case "noIdentity":
                    break
                case "noWebView":
                    break
                case "throttled":
                    break
            }
           // window.friendlyfied.plugins.AnalyticsWebPlugin.track(event[0], event[1])
        }

        function fetchTimeline(fas_timeline_req_datas, max_id, allowPagination, callback) {
            console.debug("[IGAD] fetch timeline", fas_timeline_req_datas, max_id, allowPagination)
            var req = new XMLHttpRequest()
            req.withCredentials = true
            req["fas_ignore"] = true
            req.addEventListener("load", function(){
                try {
                    console.debug("[IGAD] response", this.responseText)
                    var r = JSON.parse(this.responseText)
                    console.debug("[IGAD] json", r)
                    callback(r, allowPagination)
                    // handleResult(r, true)
                } catch(ex) {
                    console.debug("[IGAD] error", ex)
                }
            })
            req.open("POST","https://i.instagram.com/api/v1/feed/timeline/",true)
            var headers = fas_timeline_req_datas["headers"]
            //headers.forEach(function(hv){
            //    req.setRequestHeader(hv[0], hv[1])
            //})
            for (var key in headers) {
              //console.log("key " + key + " has value " + headers[key]);
              //req.setRequestHeader(key, headers[key])
            }
            // req.setRequestHeader("Host", "i.instagram.com")
            // req.setRequestHeader("Accept-Encoding", "gzip, deflate, br")
            req.setRequestHeader("User-Agent", "Instagram 123.1.0.26.115 (iPhone11,8; iOS 13_3; en_US; en-US; scale=2.00; 828x1792; 190542906)")
            var body = fas_timeline_req_datas["body"] || ""
            if (max_id && body.indexOf("max_id") < 0) {
                body += "&max_id=" + encodeURIComponent(max_id)
            }
            req.send(body)
        }

        setTimeout(function(){
            console.debug("[IG] fetch ads")
            function handleResult(r,allowPagination) {
                var success = r //&& r["igadfetch_success"]
                if (success) {
                    console.debug("[IG] timeline response", r)
                    var next_max_id = parseTimeline(success)
                    if (next_max_id && allowPagination) {
                        // call again with next max id
                        console.debug("[IG] need pagination ", next_max_id)
                        if (fas_timeline_req_datas) {
                            fetchTimeline(fas_timeline_req_datas, next_max_id, false, handleResult)
                        }
                        // window.friendlyfied.plugins.AdLogWebPlugin.asyncFetchIGAds(
                        //     {max_id: next_max_id, reqDatas:fas_timeline_req_datas}, function(r){
                        //     handleResult(r, false)
                        // })
                    } else {
                        console.debug("[IG] don't need pagination")
                    }
                }
            }
            if (fas_timeline_req_datas) {
                fetchTimeline(fas_timeline_req_datas, null,true, handleResult)
            }
        }, 3000)
        */

})