(function($, exports) {

    var PostsLib = exports.PostsLib;

    window.fas_changeColor = (function() {
        try {
            for (var i = 0; i < document.styleSheets.length; i++) {
                var style = document.styleSheets[i];
                if (style.cssRules !== undefined) {
                    for (var j = 0; j < style.cssRules.length; j++) {
                        var rule = style.cssRules[j];
                        if (rule.style && rule.style.background && rule.style.background === "rgb(56, 151, 240)") {
                            rule.style.background = window.OW_color["base"];
                        }

                        if (rule.style && rule.style.color && rule.style.color === "rgb(0, 53, 105)") {
                            rule.style.color = window.OW_color["base"];
                        }
                    }
                }
            }
        } catch (ex) {
            console.debug(ex)
        }
    });

    window.fas_displayClipBoardLink = (function(link) {
        if (!_fas_session._canShareClipboardLink() || $("#assistant_link").length)
            return;

        /*var HTML = _fas_.userHTML("clipboard_link", "html")
        setTimeout(function() {
            $("body").prepend(HTML)
            $("body #assistant_link input.link").html(link)
            $("#assistant_link img.logo").attr("src", "data:image/png;base64,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");
        }, 100);*/

        $("body").on("click", '#assistant_link .ow_playButton', function() {
            window.fas_checkAssistantInputLink()
            event.preventDefault()
        })

        $("body").on("click", '#assistant_link .ow_downloadButton', function() {
            window.fas_checkAssistantInputLink()
            event.preventDefault()
        })

        $("body").on("click", '#assistant_link .ow_shareButton', function() {
            window.fas_checkAssistantInputLink()
            event.preventDefault()
        })

        $("body").on("input", '#assistant_link #url_link_1', function() {
            var input = $(this)
            var val = input.val()
            console.debug("url_link_1 ", val)
            if (val !== undefined &&
                val.startsWith("https://www.instagram.com/p/") > 0) {
                _fas_.loadPage(val)
            }
        })
    });

    window.fas_sendLinkToUrl = (function(url) {
        if (url !== undefined && url.startsWith("https://www.instagram.com/p/") > 0) {
            ow_jQuery("#assistant_link #url_link_1").val(url)
            ow_jQuery("#assistant_link #tip_1").hide()
        } else if (url !== undefined) {
            ow_jQuery("#assistant_link #tip_1").show()
        }
    })

    window.fas_checkAssistantInputLink = (function() {
        var input = $("#assistant_link #url_link_1")
        var val = input.val()
        if (val !== undefined && val.startsWith("https://www.instagram.com/p/") > 0) {
            _fas_.loadPage(val)
        }
    })

    if (window.top == window) {
        var Bridge = (function() {
            var _ = {};
            _.browserWindowOpen = function(url) {
                if (url.indexOf("/") === 0) {
                    var port = document.location.port ? ":" + document.location.port : "";
                    url = document.location.protocol + "//" + document.location.host + port + url;
                }
                //_fas_.openTab(url);
            };
            _.init = function() {
                return _;
            };
            return _;
        })().init();

        // Instagram part -------

        var Main = (function() {
            var _ = {};
            _.fetchMoreImages2 = function() {
                console.debug("Scroll to bottom");
                window.scrollTo(0, document.body.scrollHeight);
            };

            _.fas_tryToLoadMoreImages_debounceTimeout = 0;
            _.fas_tryToLoadMoreImages = function() {
                console.debug("try to load more images");
                clearTimeout(_.fas_tryToLoadMoreImages_debounceTimeout);
                _.fas_tryToLoadMoreImages_debounceTimeout = setTimeout(function() {
                    //_.findInitialImages();
                    _.fetchMoreImages2();
                    // _.fetchMoreImages();
                }, 500);
            };

            _.metaDatasForArticle = function(article) {
                // meta data structure
                var datas = {
                    body: null,
                    storyLink: null,
                    mobileLink: null,
                    videos: [
                        // <video url>,
                    ],
                    images: [
                        /*
                        {fullSizeURL: <fullsizeimageurl>, actor: <actor identifier>}
                        */
                    ]
                }
                // actor
                var actor = article.find("> header a.notranslate[href^='/']").text();
                // article link
                var articlePostTime = article.find("a[href^='/p/'] > time");
                if (articlePostTime.length > 0) {
                    try {
                        datas.storyLink = "https://instagram.com" + articlePostTime.parent().attr("href");
                        datas.mobileLink = "https://instagram.com" + articlePostTime.parent().attr("href");
                    } catch (ex) {}
                }
                // video
                var video = article.find("video");
                if (video.length > 0) {
                    try {
                        datas.videos.push(video.attr("src"));
                    } catch (ex) {}
                }
                // image
                var image = article.find("img[srcset]");
                if (image.length > 0) {
                    try {
                        let srcs = image.attr("srcset").split(",");
                        datas.images.push({
                            fullSizeURL: srcs[srcs.length - 1].split(" ")[0],
                            actor: actor
                        })
                    } catch (ex) {}
                }
                return datas
            };


            _.start = function() {};

            _.performSearchWithTerm = function(term) {
                _fas_.log("Search with "+term["q"]);
                //console.debug("search",arguments);
                $.getJSON("/web/search/topsearch/",{context:"blended",query:term["q"],rank_token:0.7},function(r){
                    //console.debug(r);
                });

            };

            _.analyseDom = function() {
                // try to detect some classes that we need to act upon
                // find image elements
                try {
                    var foundClass = false;
                    $("body").find("noscript").each(function() {
                        var node = $(this);
                        var nextSibling = node.next();
                        var classes = nextSibling[0].classList;
                        if (classes.length == 1 && !foundClass) {
                            foundClass = classes.item(0);
                        }
                    });
                    if (foundClass) {
                        $("<style type='text/css'> div." + foundClass + "{ display:none!important;border:1px solid red!important;} </style>").appendTo("head");
                    }

                } catch (ex) {
                    console.debug(ex)
                }
            }
            _.init = function() {

                setInterval(function() {
                    window.fas_changeColor()
                }, 400);

                //_.analyseDom();

                window.fas_displayClipBoardLink()

                // update account name / avatar
                if (window._sharedData && _sharedData.config && _sharedData.config.viewer) {
                    _fas_session.updateProfile_json(JSON.stringify({
                        currentUserID: _sharedData.config.viewer.id,
                        picture: _sharedData.config.viewer.profile_pic_url,
                        name: _sharedData.config.viewer.username,
                        domain: "com.instagram"
                    }));
                } else if (!document.location.pathname.startsWith("/accounts/login")) {
                    //document.location = "https://www.instagram.com/accounts/login";
                }

               // window.fas_tryToLoadMoreImages = _.fas_tryToLoadMoreImages;
                window.fas_performSearchWithTerm = _.performSearchWithTerm;
                window.fas_willDisplayNativePhotoViewer = function() {
                    //console.debug("will display native photo viewer");
                }

                var lastWindowOpenTS = 0;
                window.ow_open = window.open;
                window.open = function() {
                    // only do it if lastWindowOpenTS is < to now - 1s
                    var ts = (new Date()).getTime();
                    if (ts - lastWindowOpenTS > 500) {
                        lastWindowOpenTS = ts;
                        return window.ow_open.apply(window, arguments);
                    } else {
                        //console.debug("Ignored open window as it's too close from last one");
                        return null;
                    }
                }

                _.start();

                return _;
            }
            window.FriendlyForFacebook = _;
            return _;
        })().init();
    }
})