(function($,exports){

    console.debug("Native ads script", exports);

    window.insertRemoveFooter = (function(dom) {
        if (!window.OW_premiumMode) {
            var removeIcon = '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" x="0px" y="0px" width="24px" height="24px" viewBox="0 0 24 24" enable-background="new 0 0 24 24" xml:space="preserve"><g id="Bounding_Boxes"><g id="ui_x5F_spec_x5F_header_copy_3" display="none"></g><path fill="none" d="M0,0h24v24H0V0z"/></g><g id="Rounded_1_"><g id="ui_x5F_spec_x5F_header_copy_6" display="none"></g><path d="M12,2C6.48,2,2,6.48,2,12s4.48,10,10,10s10-4.48,10-10S17.52,2,12,2z M4,12c0-4.42,3.58-8,8-8c1.85,0,3.55,0.63,4.9,1.69L5.69,16.9C4.63,15.55,4,13.85,4,12z M12,20c-1.85,0-3.55-0.63-4.9-1.69L18.31,7.1C19.37,8.45,20,10.15,20,12C20,16.42,16.42,20,12,20z"/></g></svg>';
            var domJ = ow_jQuery(dom);
            domJ.append("<div class='remove_ad'>" + removeIcon + _fas_session._strRemoveAd() + "<div>");
        }
    });


    // detect ads...
    function jumpFBLink(url){
        var jumpFB = false;
        if (url.indexOf("facebook.com/l.php?u=")>0){
            var u = url.split("facebook.com/l.php?u=")[1];
            return decodeURIComponent(u.split("&")[0]);
        }
        return url;
    }
    function compactArray(arr){
        var r = [];
        arr.forEach(function(e){
            if (typeof(e)=="string"){
                e = e.trim();
                if (e.length > 0){
                    r.push(e);
                }
            } else {
                r.push(e);
            }
        });
        return r;
    }
    function arraySig(arr){
        var s = "";
        arr.forEach(function(e){
            if (typeof(e)=="string"){
                if (s.length > 0){
                    s+="|";
                }
                s+=e;
            } else {
                s+="["+arraySig(e)+"]";
            }
        });
        return s;
    }

    function protect(label, fn) {
        try {
            fn();
        }catch(ex){
            console.error("[Native protect]", ex)
        }
    }

	exports.NativeAdsLib = (function(){
		var _ = {};

        _.dataFT = function(dom) {
            var dataFTJSON = dom.attr("data-ft");
            var dataFT = null;
            if (dataFTJSON) {
                try {
                    dataFT = JSON.parse(dataFTJSON);
                    return dataFT;
                } catch(ex){
                    console.error("[Native dataFT]", ex)
                }
            }
            return {};
        }

        _.isSponsored = function(dom) {
            var dataFT = _.dataFT(dom);
            return (dataFT["is_sponsored"] == 1 || dataFT["ei"]);
        };

        _.cleanedHTML = function(dom, removeEmptyTags) {
            var clone = dom.clone()
            clone.contents().each(function(){
                var e = ow_jQuery(this)
                if (removeEmptyTags && e.is(":empty")) {
                    e.remove()
                } else {
                    e.removeAttr("href").removeAttr("src").removeAttr("class").removeAttr("data-ft").removeAttr("data-xt").removeAttr("data-xt-vimp").removeAttr("data-store")
                }
            })
            return clone.html()
        }

        _.analyseDOM = function(ad) {
            var r = []
            try {
                /*ad.find("> div > div *").each(function(){
                    var e = ow_jQuery(this)
                    if (e.is("i.img[style*=\"url('\"]")) {
                        r.push({"photo":e.css("background-image")})
                    } else if (e.is("video[src]")){
                        r.push({"video":e.attr("src")})
                    } else {
                        e.contents().each(function(){
                            if (this.nodeType === 3){
                                r.push({"text": this.textContent})
                            }
                        })
                    }
                })*/
                ad.find("div.story_body_container").each(function(){
                    var block = ow_jQuery(this)
                    var pageInfos = {}
                    var postInfos = {}
                    var attachments = []
                    var footerInfos = {}
                    block.find("header:first").each(function(){
                        var header = ow_jQuery(this)
                        var avatar = header.find("i.profpic")
                        if (avatar.size() > 0){
                            pageInfos["avatar_url"] = avatar.css("background-image")
                        }
                        var name = header.find("h3 a")
                        if (name.size() > 0) {
                            pageInfos["name"] = name.text()
                            pageInfos["link"] = name.attr("href").split("?")[0]
                        }
                        // body
                        var post = header.next()
                        if (post.size() > 0) {
                            postInfos["text"] = post.text()
                            postInfos["html_text"] = _.cleanedHTML(post, true)//.html()
                        }
                        // attachment
                        var next = post.next()
                        var attachmentSection = next.find("> section")
                        if (attachmentSection.size() > 0) {
                            // attachment with footer and CTA
                            next.find("> section").each(function(){
                                var section = ow_jQuery(this)
                                var bodyInfos = {}
                                var footerInfos = {}

                                var footerDom = section.find("> section")
                                if (footerDom.size() > 0) {
                                    var bodyDom = footerDom.prev()
                                    if (bodyDom.size()> 0){
                                        bodyInfos["html_text"] = _.cleanedHTML(bodyDom, false)//.html()
                                    }
                                    var linkDom = footerDom.next("a")
                                    if (linkDom.size() > 0) {
                                        footerInfos["landingPage"] = linkDom.attr("href")
                                    }

                                    var ctaButton = footerDom.find("button[type=submit]")
                                    if (ctaButton.size() > 0) {
                                        footerInfos["cta"] = ctaButton.text()
                                        var link = ctaButton.parents("a")
                                        if (link.size() > 0) {
                                            footerInfos["landingPage"] = link.attr("href")
                                        }
                                    }
                                    var footerHeader = footerDom.find("header")
                                    if (footerHeader.size()>0){
                                        var footerText1 = footerHeader.find("> h4")
                                        if (footerText1.size() > 0) {
                                            footerInfos["topText"] = footerText1.text()
                                        }
                                        var footerText2 = footerHeader.find("> h3")
                                        if (footerText2.size() > 0) {
                                            footerInfos["centerText"] = footerText2.text()
                                        }
                                        var footerText3 = footerHeader.next()
                                        if (footerText3.size() > 0) {
                                            footerInfos["bottomText"] = footerText3.text()
                                        }
                                    }
                                }
                                attachments.push({body: bodyInfos, footer: footerInfos})
                            })
                        } else {
                            var bodyInfos = {}
                            bodyInfos["html_text"] = _.cleanedHTML(next, false)//.html()
                            attachments.push({body: bodyInfos})
                        }
                    })
                    r.push({page: pageInfos, post: postInfos, attachments: attachments})
                })
            } catch(ex){
                console.error("[Native analyseDOM]", ex)
            }
            return r
        };

        _.analyseArticle = function(article) {

            var dom = article._dom;
            if (dom.hasClass("ow_reported")) {
                return;
            }

            // ads accumulator
            var ad = null;

            if (_.isSponsored(dom)) {
                ad = {article:dom, items:[dom]};
            } else {
                // let's try in childs with [data-xt][data-ft]
                var lst = [];
                var elements = $("[data-xt][data-ft]",dom).each(function(){
                    var element = $(this);
                    if (_.isSponsored(element)){
                        lst.push(element);
                    }
                });
                if (lst.length > 0) {
                    ad = {article:dom, items:lst};
                }
            }

            if (ad != null) {
                dom.addClass("ow_reported");

                article.isAd = true;

                console.debug("found ad dom : ",article);

                var items = ad.items;

                //window.insertRemoveFooter(dom)
                //window.markDownJS(dom)

                var dataFT = _.dataFT(dom);

                var expandedItems = items.map(function(item){
                    try {
                        var avatar = $("i.profpic",item).first()
                        var source = avatar.attr("aria-label").split(",")[0]
                        var storyLink = $("footer a[data-sigil=feed-ufi-trigger]",item)
                        var content = _.analyseDOM(dom)
                        var data = {
                            "page": {
                                "name": source,
                                "id": dataFT["page_id"]
                            },
                            "post": {
                                "id": dataFT["top_level_post_id"],
                                "type": dataFT["story_attachment_style"],
                                "cta": dataFT["call_to_action_type"]
                            },
                            "content": content
                        }

                        if (storyLink.size() > 0){
                            var href = storyLink.attr("href");
                            return {"visible":!window.OW_fbAdsHide,"source":source,"url":href, "data": data};
                        } else {
                            var pageLikeContainer = $(".like_thumb_container[data-store]",item);
                            var dataStore = pageLikeContainer.attr("data-store");
                            console.debug("dataStore",dataStore)
                            var ds = JSON.parse(dataStore);
                            var href = ds["url"];
                            return {"visible":!window.OW_fbAdsHide,"source":source,"url":href, "data": data};
                        }
                    } catch(ex){
                        console.error("[Native expandedItems]", ex)
                        return null;
                    }
                });

                ad.items = expandedItems;
                if (expandedItems.length > 0) {
                    var adJson = JSON.stringify({0:expandedItems, 1:"", 2:"JS_010", 3:"facebook"})
                    _fas_.logFacebookAdGroup_json(adJson);

                    if (window.OW_fbAdsHide /*&& NativeAdManager.renderAdAfter(dom)*/) {
                        dom.remove();
                    }
                }
            }

            return;
        };

		_.detectNativeAds = function(articles){
            articles.forEach(function(article){
                try {
                    _.analyseArticle(article);
                } catch(ex){
                    console.error("[Native detectNativeAds]", ex)
                }
            });
		};

		return _;
	}());
})