(function(){
    try {

        window.fas_locationHashChanged = function() {
            try {
                if (window.location
                    && document.getElementsByTagName("html")[0] !== undefined){
                    document.getElementsByTagName("html")[0].setAttribute("data-ow-url", window.location.href)
                }
            } catch(ex){
                console.debug("fas_locationHashChanged ex=",ex)
            }
        }

        if (document.location.toString() == "about:blank") {
            _fas_.log("about:blank page... don't do anything...");
            return;
        }

        window.fas_desktopURL = function(){
            return null;
        };

        window.fas_longPressDetected = function(x,y){
            console.debug("longpress at ",x,y);
            var e = document.elementFromPoint(x, y);
            // detect text node
            var textNodes = ow_jQuery(e).contents().filter(function(){
                return this.nodeType == 3;
            });
            console.debug("longpressed element",e,textNodes);
            if (fas_longPressDetected.dataProvider) {
                var r = fas_longPressDetected.dataProvider(e,textNodes);
                console.debug(r);
                if (r){
                    _fas_.log("show menu");
                    _fas_.showMenu(r);
                } else {
                    _fas_.log("don't show menu");
                }
            }
        };

        function injectionConfigForDocument() {
            var injectionHost = "";
            var protocol = document.location.protocol;
            if (protocol == "resources:") {
                injectionHost = "about."+document.location.host;
                _fas_.log('Injection host : '+injectionHost);
            } else if (protocol == "about:") {
                // we are on a about:<some page> document...
                injectionHost = "about."+document.location.pathname;
            } else {
                injectionHost = document.location.host;
                if (injectionHost != "www.facebook.com" && injectionHost.endsWith("facebook.com")) {
                    injectionHost = "facebook.com";
                } else if (injectionHost.endsWith("instagram.com")) {
                    injectionHost = "instagram.com";
                } else if (injectionHost.endsWith("x.com")) {
                    injectionHost = "x.com";
                } else if (injectionHost.endsWith("tumblr.com")) {
                    injectionHost = "tumblr.com";
                } else if (injectionHost == "www.facebook.com") {
                    injectionHost = "desktop.facebook.com";
                } else if (injectionHost == "twitter.com") {
                    injectionHost = "x.com";
                }
            }

            console.log("injectionConfigForDocument injectionHost", injectionHost)
            if (injectionHost === undefined || injectionHost === "")
                return "{}"

            var conf = _fas_.userscript(injectionHost+".conf","json");
            console.debug(conf);

            if (conf && conf!= "") {
                _fas_.log(conf);
                return JSON.parse(conf);
            } else {
                return {
                    "css":{
                        "head":[injectionHost+".head"],
                        "beforeLoad":[injectionHost+".beforeLoad"],
                        "interactive":[injectionHost+".interactive"],
                        "complete":[injectionHost+".complete"]
                    },
                    "js":{
                        "head":[injectionHost+".head"],
                        "beforeLoad":[injectionHost+".beforeLoad"],
                        "interactive":[injectionHost+".interactive"],
                        "complete":[injectionHost+".complete"]
                    }
                };
            }
        }

        var exports = {};
        window.evaluatedFunctionParameters = {};

        function injectJS(name) {
            try {
                window.evaluatedFunctionParameters[name] = [ow_jQuery, exports]
                _fas_.safeEval(name, "js")
             } catch(ex){
                console.debug("injectJS name = ", name)
                console.debug("injectJS ex = ", ex)
             }
        }

        function evaluateCSSTemplate(css) {
            try {
                var settings = JSON.parse(_fas_.json_settings());
                var colors = settings["colors"];
                var options = settings["options"];
                for (var c in colors) {
                    var cssColor = colors[c];
                    css = css.replaceAll("{"+c+"Color}",cssColor);
                }
                for (var c in options) {
                    css = css.replaceAll("{"+c+"}",options[c]);
                }
            } catch(ex){
                console.debug(ex)
            }
            return css
        }

        function injectCSS(name) {
            try {
                var css = _fas_.userscript(name, "css");
                if (css){
                    css = evaluateCSSTemplate(css);
                    var headDom = document.head || document.getElementsByTagName('head')[0];
                    var styleDom = document.createElement('style');
                    styleDom.type = 'text/css';
                    styleDom.id = "css_"+name;
                    if (styleDom.styleSheet){
                      styleDom.styleSheet.cssText = css;
                    } else {
                      styleDom.appendChild(document.createTextNode(css));
                    }
                    headDom.appendChild(styleDom);

                    _fas_.log("CSS Added to document head");
                }

            } catch(ex){
                console.debug(ex)
            }
        }


        var onInteractivePassed = false;

        function injectAtState(conf,state){
            // css :
            if ((cssConf = conf["css"]) && (cssList = cssConf[state])) {
                cssList.forEach(function(css){
                    _fas_.log("inject css "+css);
                    injectCSS(css);
                });
            }
            // js:
            if ((jsConf = conf["js"]) && (jsList = jsConf[state])) {
                jsList.forEach(function(js){
                    _fas_.log("running js "+js);
                    injectJS(js);
                });
            }
        }

        function onHead(conf){
            console.debug("execute onHead", conf);
            try {
                injectAtState(conf, "head");
            } catch(ex){
                _fas_.log("Exception in onHead "+ex.toString());
            }
        }

        function onBeforeLoad(conf) {
            console.debug("onBeforeLoad", conf);
            try {
                injectAtState(conf, "beforeLoad");
            } catch(ex){
                _fas_.log("Exception in onBeforeLoad "+ex.toString());
            }
        }

        function onInteractive(conf) {
            console.debug("onInteractive",conf);
            try {
                injectAtState(conf,"interactive");
            } catch(ex){
                _fas_.log("Exception in onInteractive "+ex.toString());
            } finally {
                onInteractivePassed = true;
            }

        }

        function onComplete(conf) {
            console.debug("onComplete",conf);
            try {
                var og = {};
                ow_jQuery('meta[property^="og:"]').each(function(){
                    var meta = ow_jQuery(this);
                    og[meta.attr("property")] = meta.attr("content");
                });
                if (_fas_.history !== undefined) {
                    _fas_.history.append({
                        title: document.title,
                        url:document.location.toString(),
                        og:og
                    });
                }
            } catch(ex){
                _fas_.log("Exception parsing og metadata "+ex.toString());
            }

            try {
                injectAtState(conf,"complete");
            }catch(ex){
                _fas_.log("Exception in onComplete "+ex.toString());
            }

        }

        var injectionConf = injectionConfigForDocument();
        console.debug(injectionConf);

        window.fas_updateSkin = (function(injectionConf){
            return function(){
                setTimeout(function(){
                    var cssConf = injectionConf["css"];
                    for (var state in cssConf){
                        var cssList = cssConf[state];
                        cssList.forEach(function(name){
                            var css = _fas_.userscript(name,"css");
                            if (css){
                                css = evaluateCSSTemplate(css);
                                var element = document.getElementById("css_"+name);
                                element.parentNode.removeChild(element);
                                var styleDom = document.createElement('style');
                                styleDom.type = 'text/css';
                                styleDom.id = "css_"+name;
                                if (styleDom.styleSheet){
                                  styleDom.styleSheet.cssText = css;
                                } else {
                                  styleDom.appendChild(document.createTextNode(css));
                                }
                                document.head.appendChild(styleDom);
                            }
                        });
                    }
                }, 10);
            };
        })(injectionConf);

        onBeforeLoad(injectionConf);

        if (document.head) {
            console.debug("Document's head Already there");
            onHead(injectionConf);
        } else {
            console.debug("Waiting for document's head...");
            //  (function(){
            try {
                // select the target node
                var target = document;
                console.debug("Document's head not ready, let's observe");
                // create an observer instance
                var observer = new MutationObserver(function(mutations) {
                    mutations.forEach(function(mutation) {
                        console.log("onContextReady observed mutation on document:",mutation);
                    });
                    if (head = document.head) {
                        console.log("document's head ready");
                        observer.disconnect();
                        onHead(injectionConf);
                        window.fas_locationHashChanged();
                    }
                });
                // configuration of the observer:
                var config = { childList: true, characterData: false,subtree:false };
                // pass in the target node, as well as the observer options
                observer.observe(target, config);
            }catch(ex){
                console.debug(ex);
            }
        }

        if ( document.readyState == "complete" ) {
            onInteractive(injectionConf);
            onComplete(injectionConf);
        } else {
            document.onreadystatechange = function(){
                if (document.readyState == "interactive") {
                    onInteractive(injectionConf);
                } else if (document.readyState == "complete") {
                    if (!onInteractivePassed) {
                        onInteractive(injectionConf);
                    }
                    onComplete(injectionConf);
                }
            }
        }

        return;
    } catch(ex){
        console.debug("onContextReady ex=",ex)
        _fas_.log(ex.toString());
    }
})();