////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;

// 原始图形纹理
uniform sampler2D inputImageTexture;
// 融合素材纹理
uniform sampler2D inputImageTexture2;
// 橡皮擦纹理
uniform sampler2D inputImageTexture3;
// 真实度调整纹理
uniform sampler2D uBlendRealTexture;

// 融合矩阵
uniform mat4 mBlendMatrix;
//亮度加法调整, 范围 -1~1
uniform float uTexture2Brightness;
// 透明度变更值 0～1
uniform float uTexture2Alpha;
// 颜色值 rgb
uniform vec3 uColorData;
// 是否有第三个纹理
uniform int uHasTexture3;
// 融合模式 1 darken， 2 multiply
uniform int uBlendMode;
// 是否有真实度纹理
uniform int uHasBlendReal;
// 真实度值 0～1
uniform float uRealistic;

uniform float uColorProgress;

vec3 rgb2hsv(vec3 c) {
    vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
    vec4 p = c.g < c.b ? vec4(c.bg, K.wz) : vec4(c.gb, K.xy);
    vec4 q = c.r < p.x ? vec4(p.xyw, c.r) : vec4(c.r, p.yzx);
    float d = q.x - min(q.w, q.y);
    float e = 1.0e-10;
    return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

vec3 hsv2rgb(vec3 c) {
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
}

vec4 changeColorByHsl(float colorProgress, vec4 originColor) {
    if (colorProgress != -1.) {
        vec3 hsl = rgb2hsv(originColor.rgb);
        hsl.x = hsl.x > .8 ? hsl.x - 1. : hsl.x;
        originColor = vec4(hsv2rgb(vec3(hsl.x + colorProgress / 100., hsl.y, hsl.z)), originColor.a);
    }
    return originColor;
}

// 变暗
vec4 darken(vec4 base, vec4 overlayer) {
    float alpha = base.a + overlayer.a * (1.0 - base.a);
    return vec4(min(overlayer.rgb * base.a, base.rgb * overlayer.a) + overlayer.rgb * (1.0 - base.a) + base.rgb * (1.0 - overlayer.a), alpha);
}

// 正片叠底
vec4 multiply(vec4 s, vec4 d) {
    return s * d + s * (1.0 - d.a) + d * (1.0 - s.a);
}

// 叠加
vec4 overlay(vec4 base, vec4 overlay) {
    mediump float ra;
    if (2.0 * base.r < base.a) {
        ra = 2.0 * overlay.r * base.r + overlay.r * (1.0 - base.a) + base.r * (1.0 - overlay.a);
        ra = 2.0 * overlay.r * ra + overlay.r * (1.0 - base.a) + ra * (1.0 - overlay.a);
    } else {
        ra = overlay.a * base.a - 2.0 * (base.a - base.r) * (overlay.a - overlay.r) + overlay.r * (1.0 - base.a) + base.r * (1.0 - overlay.a);
        ra = overlay.a * base.a - 2.0 * (base.a - ra) * (overlay.a - overlay.r) + overlay.r * (1.0 - base.a) + ra * (1.0 - overlay.a);
    }
    mediump float ga;
    if (2.0 * base.g < base.a) {
        ga = 2.0 * overlay.g * base.g + overlay.g * (1.0 - base.a) + base.g * (1.0 - overlay.a);
        ga = 2.0 * overlay.g * ga + overlay.g * (1.0 - base.a) + ga * (1.0 - overlay.a);
    } else {
        ga = overlay.a * base.a - 2.0 * (base.a - base.g) * (overlay.a - overlay.g) + overlay.g * (1.0 - base.a) + base.g * (1.0 - overlay.a);
        ga = overlay.a * base.a - 2.0 * (base.a - ga) * (overlay.a - overlay.g) + overlay.g * (1.0 - base.a) + ga * (1.0 - overlay.a);
    }

    mediump float ba;
    if (2.0 * base.b < base.a) {
        ba = 2.0 * overlay.b * base.b + overlay.b * (1.0 - base.a) + base.b * (1.0 - overlay.a);
        ba = 2.0 * overlay.b * ba + overlay.b * (1.0 - base.a) + ba * (1.0 - overlay.a);
    } else {
        ba = overlay.a * base.a - 2.0 * (base.a - base.b) * (overlay.a - overlay.b) + overlay.b * (1.0 - base.a) + base.b * (1.0 - overlay.a);
        ba = overlay.a * base.a - 2.0 * (base.a - ba) * (overlay.a - overlay.b) + overlay.b * (1.0 - base.a) + ba * (1.0 - overlay.a);
    }

    float alpha = overlay.a + base.a * (1.0 - overlay.a);
    return vec4(ra, ga, ba, alpha);
}

// 强光
vec4 strongLight(vec4 overlay, vec4 base) {
    highp float ra;
    if (2.0 * overlay.r < overlay.a) {
        ra = 2.0 * overlay.r * base.r + overlay.r * (1.0 - base.a) + base.r * (1.0 - overlay.a);
    } else {
        ra = overlay.a * base.a - 2.0 * (base.a - base.r) * (overlay.a - overlay.r) + overlay.r * (1.0 - base.a) + base.r * (1.0 - overlay.a);
    }

    highp float ga;
    if (2.0 * overlay.g < overlay.a) {
        ga = 2.0 * overlay.g * base.g + overlay.g * (1.0 - base.a) + base.g * (1.0 - overlay.a);
    } else {
        ga = overlay.a * base.a - 2.0 * (base.a - base.g) * (overlay.a - overlay.g) + overlay.g * (1.0 - base.a) + base.g * (1.0 - overlay.a);
    }

    highp float ba;
    if (2.0 * overlay.b < overlay.a) {
        ba = 2.0 * overlay.b * base.b + overlay.b * (1.0 - base.a) + base.b * (1.0 - overlay.a);
    } else {
        ba = overlay.a * base.a - 2.0 * (base.a - base.b) * (overlay.a - overlay.b) + overlay.b * (1.0 - base.a) + base.b * (1.0 - overlay.a);
    }
    float alpha = overlay.a + base.a * (1.0 - overlay.a);
    return vec4(ra, ga, ba, alpha);
}

void main() {
    vec4 coordinate = vec4(textureCoordinate, 0., 1.);
    coordinate = mBlendMatrix * coordinate;
    if (coordinate.x < 0.0 || coordinate.x > 1.0 || coordinate.y < 0.0 || coordinate.y > 1.0) {
        gl_FragColor = texture2D(inputImageTexture, textureCoordinate);
        return;
    }
    mediump vec4 blendColor = texture2D(inputImageTexture2, coordinate.xy);

    if (uColorProgress >= 0.) {
        blendColor = changeColorByHsl(uColorProgress, blendColor);
    } else if (uColorData.r >= 0.0 && uColorData.g >= 0.0 && uColorData.b >= 0.0) {
        blendColor = vec4(uColorData, 1.0) * blendColor.a;
    }

    if (uHasBlendReal == 1) {
        mediump vec4 blendRealColor = texture2D(uBlendRealTexture, coordinate.xy);
        blendRealColor = blendRealColor * uRealistic;
        blendColor = (blendRealColor * (1.0 - blendColor.a)) + blendColor;
    }

    float extAlpha = uTexture2Alpha;
    if (uHasTexture3 == 1) {
        vec4 maskColor = texture2D(inputImageTexture3, coordinate.xy);
        extAlpha *= maskColor.a;
    }
    vec3 result = (blendColor.rgb + vec3(uTexture2Brightness) * blendColor.a);
    blendColor = vec4(result, blendColor.a) * extAlpha;
    if (blendColor.r > blendColor.a) {
        blendColor.r = blendColor.a;
    }
    if (blendColor.g > blendColor.a) {
        blendColor.g = blendColor.a;
    }
    if (blendColor.b > blendColor.a) {
        blendColor.b = blendColor.a;
    }

    mediump vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    if (uBlendMode == 4) {
        gl_FragColor = overlay(srcColor, blendColor);
    } else if (uBlendMode == 3) {
        gl_FragColor = strongLight(srcColor, blendColor);
    } else if (uBlendMode == 2) {
        gl_FragColor = darken(srcColor, blendColor);
    } else if (uBlendMode == 0) {
        gl_FragColor = multiply(srcColor, blendColor);
    } else {
        vec4 finalColor = (srcColor * (1.0 - blendColor.a)) + blendColor;
        gl_FragColor = finalColor;
    }
}