////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;

uniform mat4 mBlendMatrix;
uniform float mLimitPosition[4];
uniform int misSwipLocation;
const float threshold = 0.002;
bool isOutside(vec2 uv){
    return uv.x <0.0 || uv.x >1.0 ||uv.y <0.0 || uv.y >1.0;
}


void main()
{
    bool isSwip = misSwipLocation == 0;


    vec4 coordinate = vec4(textureCoordinate, 0., 1.);
    coordinate= mBlendMatrix * coordinate;
    if (isOutside(coordinate.xy)){
        gl_FragColor = vec4(0.0);
        return;
    }

    vec4 srcColor= texture2D(inputImageTexture, coordinate.xy);
    if(isSwip){
        gl_FragColor = srcColor;

    }else{
        vec4 areaColor = texture2D(inputImageTexture2, textureCoordinate);
        float parms = threshold;
        if (abs(coordinate.x) < threshold){
            parms = abs(coordinate.x);
        }else if(abs(coordinate.x - 1.0) <threshold){
            parms = abs(coordinate.x- 1.0);
        }else if(abs(coordinate.y) <threshold){
            parms = abs(coordinate.y);
        }else if(abs(coordinate.y-1.0) <threshold){
            parms = abs(coordinate.y-1.0);
        }
        parms = parms/threshold;
        srcColor = srcColor * parms;
        gl_FragColor = areaColor.a * srcColor;
    }
}