////// Fragment Shader
precision highp float;


varying highp vec2 textureCoordinate;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D blurTexture;

uniform float intensity;
uniform float secondProgress;
uniform float thirdProgress;
uniform int type;

uniform int frontBackType;

uniform int eraserType;

vec4 blendBling(vec4 blendColor, vec4 baseColor) {
    return blendColor * 1.5 + baseColor;
}

vec4 blendFacula(vec4 blendColor, vec4 baseColor) {
    highp float ra;
    if (2.0 * blendColor.r < blendColor.a) {
        ra = 2.0 * blendColor.r * baseColor.r + blendColor.r * (1.0 - baseColor.a) + baseColor.r * (1.0 - blendColor.a);
    } else {
        ra = blendColor.a * baseColor.a - 2.0 * (baseColor.a - baseColor.r) * (blendColor.a - blendColor.r) + blendColor.r * (1.0 - baseColor.a) + baseColor.r * (1.0 - blendColor.a);
    }

    highp float ga;
    if (2.0 * blendColor.g < blendColor.a) {
        ga = 2.0 * blendColor.g * baseColor.g + blendColor.g * (1.0 - baseColor.a) + baseColor.g * (1.0 - blendColor.a);
    } else {
        ga = blendColor.a * baseColor.a - 2.0 * (baseColor.a - baseColor.g) * (blendColor.a - blendColor.g) + blendColor.g * (1.0 - baseColor.a) + baseColor.g * (1.0 - blendColor.a);
    }

    highp float ba;
    if (2.0 * blendColor.b < blendColor.a) {
        ba = 2.0 * blendColor.b * baseColor.b + blendColor.b * (1.0 - baseColor.a) + baseColor.b * (1.0 - blendColor.a);
    } else {
        ba = blendColor.a * baseColor.a - 2.0 * (baseColor.a - baseColor.b) * (blendColor.a - blendColor.b) + blendColor.b * (1.0 - baseColor.a) + baseColor.b * (1.0 - blendColor.a);
    }
    return vec4(ra, ga, ba, max(blendColor.a, baseColor.a));
}

vec4 normalBlend(vec4 d, vec4 s) {
    vec4 c;
    c.r = s.r + d.r * d.a * (1.0 - s.a);
    c.g = s.g + d.g * d.a * (1.0 - s.a);
    c.b = s.b + d.b * d.a * (1.0 - s.a);
    c.a = s.a + d.a * (1.0 - s.a);
    return c;
}

void main() {
    mediump vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate);
    mediump vec4 maskColor = vec4(0.0);
    if (frontBackType != 0) {
        maskColor = texture2D(inputImageTexture3, textureCoordinate);
    }
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);

    vec4 blurcolor = texture2D(blurTexture, textureCoordinate);

    float blingLight = intensity + 0.5;
    if (type == 0) {
        blendColor = blendBling(blingLight * blendColor, srcColor);
    } else if (type == 1) {
        blendColor = blendFacula(blendColor * (secondProgress / 100.0 + 0.5), blurcolor);
    } else {
        blendColor = normalBlend(srcColor, blendColor * blingLight);
    }


    if (frontBackType != 0|| eraserType != 0){
        vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
        gl_FragColor= mix(blendColor, srcColor, maskColor.a );
    } else {
        gl_FragColor= blendColor;
    }


}