////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图

uniform sampler2D inputImageTexture;
uniform  float intensity;
uniform  vec2 inputSize;
uniform float mCenterOffset[2];

vec4 myFunction(vec2 uv){
    vec2 inputSize2 = inputSize;
    vec2 center = vec2(inputSize2.x * (0.5 +mCenterOffset[0]), inputSize2.y * (0.5 + mCenterOffset[1]));
    vec2 realCoord = uv * inputSize2;
    vec2 dxy = realCoord - center;
    float r = length(dxy);
    vec4 color = vec4(0.0);
    highp float angle = atan(dxy.y, dxy.x);
    float  newX, newY;
    float count = 0.0;
    highp float level = (intensity + 0.1)/200.0;
    float ratio = inputSize2.x / inputSize2.y;
    for (float i = -10.0; i < 10.0; i++){
        highp float resultAngle  = angle + level * i;
        newX = r * cos(resultAngle) + center.x;
        newY = r * sin(resultAngle)  + center.y;
        color += texture2D(inputImageTexture, vec2(newX, newY)/inputSize2);

        newX = (r +0.5)  * cos(resultAngle) + center.x;
        newY = (r +0.5)  * sin(resultAngle)  + center.y;
        color += texture2D(inputImageTexture, vec2(newX, newY)/inputSize2) *0.5;

        newX = (r +0.5)  * cos(resultAngle) + center.x;
        newY = (r +0.5)  * sin(resultAngle)  + center.y;
        color += texture2D(inputImageTexture, vec2(newX, newY)/inputSize2) *0.5;
        count += 2.0;
    }
    color  /=count;
    return color;
}

void main(){

    gl_FragColor = myFunction(textureCoordinate);

}


