////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图
uniform sampler2D inputImageTexture;
uniform  float intensity;
uniform float mCenterOffset[2];
vec4 myFunction(vec2 uv){
    const float iterations = 20.;
    vec2 center = vec2(0.5+mCenterOffset[0] ,0.5 +mCenterOffset[1]);
    vec4 color = vec4(0.);
    float total = 0.;
    vec2 toCenter = center - uv;
    float level = (intensity + 0.25) /6.;
    for (float t=0.; t<=iterations; t++){
        float percent = t/iterations;
        float weight = 4.0*(percent-percent*percent);
        vec4 currenColor = texture2D(inputImageTexture, uv+ toCenter*percent * level);
        currenColor.rgb *= currenColor.a;
        color += currenColor*weight;
        total += weight;
    }
    color = color/total;
    return color;
}

void main(){
    gl_FragColor = myFunction(textureCoordinate) ;
}


