////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图

uniform sampler2D inputImageTexture;
uniform  vec2 inputSize;
uniform  float mBlurRotation;


vec4 myFunction(vec2 uv){
    float level = 2.0;
    vec2 unit = level / inputSize;
    float r = 10.;
    float count = 0.0;
    vec4 col = vec4(0);
    float rotation = radians(mBlurRotation *3.6);
    for (float i = 1.0-r; i < r; i += 1.0){
        vec2 realUv = uv+ vec2(i * unit.x * cos(rotation), i * unit.y * sin(rotation));
        col += texture2D(inputImageTexture, realUv);
        count++;
    }
    col /= count;
    return col;
}

void main(){
    gl_FragColor = myFunction(textureCoordinate);
}


