////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform int frontBackType;
uniform  float intensity;
uniform  vec2 inputSize;

uniform int eraserType;

vec4 myFunction(vec2 uv){
    float tile_num = (30.- intensity * 20.0);
    float  mosaicW =inputSize.x;
    float  mosaicH =inputSize.y;
    highp vec2 tile = vec2(tile_num, tile_num *mosaicH /mosaicW);
    highp vec2 uv2 = floor(uv * tile) / tile;
    uv -= uv2;
    uv *= tile;
    float onePix = 8.0/max(inputSize.x, inputSize.y);
    float distance1 =0.0, distance2 = 0.0;
    vec4 color1 =vec4(0), color2 = vec4(0);
    vec2 offset = vec2(0.0);
    vec2 left = vec2(0.0, 0.5), top = vec2(0.5, 0.0), right = vec2(1.0, 0.5), bottom = vec2(0.5, 1.0);
    if (abs(uv.y - uv.x) < onePix) {
        distance1 = uv.x > 0.5 ? length(uv-right) :length(uv-left);
        distance2 = uv.x > 0.5?length(uv-bottom) :length(uv-top);
        color1 = texture2D(inputImageTexture, uv2 + 1.0 / (2.0 * tile) + vec2(sign(uv.x- 0.5)  / (4.0 * tile.x), 0.0));
        color2 = texture2D(inputImageTexture, uv2 + 1.0 / (2.0 * tile) + vec2(0.0, sign(uv.x- 0.5)  / (4.0 * tile.y)));
        return mix(color1, color2, smoothstep(-0.15, 0.15, distance1 - distance2));
    } else if (abs(uv.y -1.0 + uv.x) < onePix){
        distance1 = uv.x > 0.5 ? length(uv-right) : length(uv-left);
        distance2 = uv.x > 0.5 ? length(uv-top) : length(uv-bottom);
        color1 = texture2D(inputImageTexture, uv2 + 1.0 / (2.0 * tile) + vec2(sign(uv.x - 0.5) / (4.0 * tile.x), 0.0));
        color2 = texture2D(inputImageTexture, uv2 + 1.0 / (2.0 * tile) + vec2(0.0, -sign(uv.x- 0.5)/ (4.0 * tile.y)));
        return mix(color1, color2, smoothstep(-0.15, 0.15, distance1 - distance2));
    } else {
        if (uv.y > uv.x) {
            offset.x = -1.0 / (4.0 * tile.x) *  step(uv.x, 1.0 - uv.y);
            offset.y = 1.0 / (4.0 * tile.y)  * step(1.0 - uv.y, uv.x);
        } else {
            offset.x = 1.0 / (4.0 * tile.x)  * step(1.0 - uv.y, uv.x);
            offset.y = -1.0 / (4.0 * tile.y) *  step(uv.x, 1.0 - uv.y);
        }
        return texture2D(inputImageTexture, uv2 + 1.0 / (2.0 * tile) + offset);
    }
}

void main(){
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = myFunction(textureCoordinate);


        if (frontBackType != 0|| eraserType != 0){
            vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
            gl_FragColor= mix(blendColor, srcColor, maskColor.a);
        } else {
            gl_FragColor= blendColor;
        }

}


