////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform int frontBackType;
uniform float intensity;
uniform vec2 inputSize;

uniform int eraserType;

vec4 myFunction(vec2 uv){
    float tile_num = intensity ;
    vec2 tile = vec2(tile_num, tile_num * inputSize.y / inputSize.x);
    vec2 uv2 = floor(uv*tile)/tile;
    uv -= uv2;
    uv *= tile;
    vec2 offset = vec2(0.0);
    vec2 circleCoordinate = uv;
    if (uv.y > 0.5) {
        if (uv.x < 0.5) {
            offset.x = -1.0/(4.0*tile.x);
        } else {
            offset.y = 1.0/(4.0*tile.y);
        }
    } else {
        if (uv.x < 0.5) {
            offset.y = -1.0/(4.0*tile.y);
        } else {
            offset.x = 1.0/(4.0*tile.x);
        }
    }
    circleCoordinate = uv2 + 1.0/(2.0*tile) + offset;
    float difference = distance(uv*vec2(inputSize.x/tile_num), vec2(0.5)*vec2(inputSize.x/tile_num)) - inputSize.x/(tile_num*2.0);

    vec4 color1 = texture2D(inputImageTexture, uv2 + 1.0/(6.0*tile));
    vec4 color2 = texture2D(inputImageTexture, uv2 + 1.0/(2.0*tile) + offset);
    float r = 2.0;
    return mix(color1, color2, smoothstep(-r, r, difference));
}

void main(){
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = myFunction(textureCoordinate) ;
    blendColor = vec4(blendColor.rgb * srcColor.a,srcColor.a);


        if (frontBackType != 0|| eraserType != 0){
            vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
            gl_FragColor= mix(blendColor, srcColor, maskColor.a);
        } else {
            gl_FragColor= blendColor;
        }

}


