////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform int frontBackType;
uniform  float intensity;
uniform  vec2 inputSize;

uniform int eraserType;

vec4 myFunction(){
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    highp float tile_num = 80. - intensity *70.;
    highp vec2 tile = vec2(tile_num, tile_num * inputSize.y / inputSize.x);
    highp vec2 uv = textureCoordinate;
    uv = floor(uv * tile) / tile + 0.5 / tile;
    return texture2D(inputImageTexture, uv);
}

void main(){
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = myFunction();
    blendColor = vec4(blendColor.rgb * srcColor.a, srcColor.a);


        if (frontBackType != 0|| eraserType != 0){
            vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
            gl_FragColor= mix(blendColor, srcColor, maskColor.a);
        } else {
            gl_FragColor= blendColor;
        }


}


