////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;//原图

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D eraserTexture;
uniform int eraserType;
uniform int frontBackType;

void main(){
    vec4 srcColor=texture2D(inputImageTexture, textureCoordinate);
    vec4 blendColor = texture2D(inputImageTexture2, textureCoordinate) * srcColor.a;
    blendColor = vec4(blendColor.rgb * srcColor.a, srcColor.a);
    if (frontBackType != 0|| eraserType != 0){
        vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
        gl_FragColor= mix(blendColor, srcColor, maskColor.a);
    } else {
        gl_FragColor= blendColor;
    }

}