precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform float gradientColor[21];
uniform int gradientCount;
uniform float degree;
uniform float width;
uniform float height;
uniform int mBgType;
uniform highp vec2 repeatCount;

uniform highp vec2 inputSize;
const int maxLength = 7;
uniform float locations[maxLength];
uniform float startPoint[2];
uniform float endPoint[2];

vec4 drawGradientBg() {
    float realDegree = (100.0 - degree) + 50.0;
    realDegree = mod(realDegree, 100.0);
    float degreeResult = 360.0 - realDegree * 3.6;
    float gradientDegree;
    if (degreeResult >= 0.0 && degreeResult < 90.0) {
        gradientDegree = degreeResult;
    } else if (degreeResult > 90.0 && degreeResult <= 180.0) {
        gradientDegree = degreeResult - 90.0;
    } else if (degreeResult > 180.0 && degreeResult <= 270.0) {
        gradientDegree = degreeResult - 180.0;
    } else {
        gradientDegree = degreeResult - 270.0;
    }

    float radian = radians(gradientDegree);
    float newWdith = width * (cos(radian)) + height * (sin(radian));
    float newHeight = width * (sin(radian)) + height * (cos(radian));

    float posx = textureCoordinate.x * width;
    float posy = textureCoordinate.y * height;

    float newY = 0.0;
    if (degreeResult >= 0.0 && degreeResult < 90.0)
    newY = posy * cos(radian) + (width - posx) * sin(radian);
    else if (degreeResult >= 90.0 && degreeResult <= 180.0) {
        float temp = newWdith;
        newWdith = newHeight;
        newHeight = temp;
        newY = newHeight - (posx * cos(radian) + posy * sin(radian));
    } else if (degreeResult > 180.0 && degreeResult <= 270.0) {
        newY = (height - posy) * cos(radian) + posx * sin(radian);
    } else {
        float temp = newWdith;
        newWdith = newHeight;
        newHeight = temp;
        newY = posx * cos(radian) + posy * sin(radian);
    }
    float percent = newY / newHeight;
    float indexF = percent * (float(gradientCount) - 1.0);
    int index = int(indexF);
    float off = indexF - float(index);
    vec3 curPix;
    curPix.r = gradientColor[0 + index * 3] + (gradientColor[3 + index * 3] - gradientColor[0 + index * 3]) * off;
    curPix.g = gradientColor[1 + index * 3] + (gradientColor[4 + index * 3] - gradientColor[1 + index * 3]) * off;
    curPix.b = gradientColor[2 + index * 3] + (gradientColor[5 + index * 3] - gradientColor[2 + index * 3]) * off;
    return vec4(curPix, 1.0);
}

vec4 drawPatternBg() {
    float percentWidth, percentHeight, resultX, resultY;
    int indexX, indexY;
    percentWidth = 1.0 / repeatCount.x;
    indexX = int(textureCoordinate.x / percentWidth);
    resultX = (textureCoordinate.x - float(indexX) * percentWidth) / percentWidth;
    percentHeight = 1.0 / repeatCount.y;
    indexY = int(textureCoordinate.y / percentHeight);
    resultY = (textureCoordinate.y - float(indexY) * percentHeight) / percentHeight;
    return texture2D(inputImageTexture, vec2(resultX, resultY));
}

vec4 drawBlurBg() {
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 defaultColor = vec4(0.14, 0.14, 0.14, 1.0);
    return defaultColor * (1.0 - srcColor.a) + srcColor;
}

/**
* 画圆环形背景
*/
vec4 drawCircleGradientBg() {
    vec2 st = textureCoordinate;
    vec3 color;
    float widthRatio = inputSize.x / inputSize.y;
    vec2 centerPoint = vec2(startPoint[0] * widthRatio, startPoint[1]);
    vec2 edgePoint = vec2(endPoint[0] * widthRatio, endPoint[1]);
    vec2 currentPoint = vec2(st.x * widthRatio, st.y);
    float r = distance(centerPoint, edgePoint);
    float dist = distance(centerPoint, currentPoint);
    // 扩充圆环比例， 0.7～1.6
    float realDegree = (70.0 + degree * 0.9) / 100.0;
    for (int i = 0; i < maxLength; i++) {
        float location = locations[i] * realDegree;
        if (i >= gradientCount - 1) {
            if (dist / r > location) {
                color = vec3(gradientColor[i * 3], gradientColor[i * 3 + 1], gradientColor[i * 3 + 2]);
            } else {
                color = vec3(gradientColor[0], gradientColor[1], gradientColor[2]);
            }
            break;
        }
        float nextLocation = locations[i + 1] * realDegree;
        if (dist / r >= location && dist / r <= nextLocation) {
            float diff0 = dist / r - location;
            float diff1 = nextLocation - location;
            vec3 startColor = vec3(gradientColor[i * 3], gradientColor[i * 3 + 1], gradientColor[i * 3 + 2]);
            vec3 endColor = vec3(gradientColor[(i + 1) * 3], gradientColor[(i + 1) * 3 + 1], gradientColor[(i + 1) * 3 + 2]);
            color = mix(startColor, endColor, diff0 / diff1);
            break;
        }
    }
    return vec4(color, 1.0);
}

void main()
{
    if (mBgType == 2) {
        gl_FragColor = drawBlurBg();
    } else if (mBgType == 4) {
        gl_FragColor = drawPatternBg();
    } else if (mBgType == 1) {
        if (abs(startPoint[0] - endPoint[0]) < 0.000001 && abs(startPoint[1] - endPoint[1]) < 0.000001) {
            gl_FragColor = drawGradientBg();
        } else {
            gl_FragColor = drawCircleGradientBg();
        }
    } else if (mBgType == 8) {
        gl_FragColor = vec4(0);
    }
}