////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform vec2 inputSize;
uniform vec2 centerPoint;
uniform float radius;
uniform float scale;
uniform  float ratio;
vec2 zoomUv(vec2 uv, float value, float radius, vec2 centerPoint){
    float scale = value/10.0 +1.0;
    vec2 dir = uv - centerPoint;
    dir.x *= ratio;
    float dist = length(dir);
    vec2 firstOffset;
    if (dist < radius) {
        float t = (radius - dist) / radius;
        float scaleFactor = mix(1.0, scale, t);
        dir *= scaleFactor;
        dir.x /= ratio;
        uv = centerPoint + dir;
    }
    return uv;
}

void main()
{
    vec2 uv =  zoomUv(textureCoordinate, scale, radius, centerPoint);
    gl_FragColor = texture2D(inputImageTexture, uv);
}