////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform vec2 mEdgePoint[4];
uniform float intensity;
uniform  float ratio;
//uniform float mRadian;

float pointDistanceToLine(vec2 p, vec2 a, vec2 b) {
    vec2 ap = p - a;
    vec2 ab = b - a;
    float ab2 = dot(ab, ab);
    float ap_ab = dot(ap, ab);
    float t = ap_ab / ab2;
    vec2 c = a + t * ab;
    return length(p - c);
}

bool isPointInRectangle(vec2 p, vec2 a, vec2 b, vec2 c, vec2 d) {
    // Vector cross product to check if the point is on the correct side of each edge
    vec2 ab = b - a;
    vec2 ap = p - a;
    vec2 bc = c - b;
    vec2 bp = p - b;
    vec2 cd = d - c;
    vec2 cp = p - c;
    vec2 da = a - d;
    vec2 dp = p - d;

    float cross1 = ab.x * ap.y - ab.y * ap.x;
    float cross2 = bc.x * bp.y - bc.y * bp.x;
    float cross3 = cd.x * cp.y - cd.y * cp.x;
    float cross4 = da.x * dp.y - da.y * dp.x;
    return (cross1 >= 0.0 && cross2 >= 0.0 && cross3 >= 0.0 && cross4 >= 0.0);
}

bool  checkPointIsLeft(vec2 line1, vec2 line2, vec2 checkPoint) {
    // Calculate the cross product
    float crossProduct = (line2.x - line1.x) * (checkPoint.y - line1.y) - (line2.y -line1.y) * (checkPoint.x - line1.x);
    return crossProduct > 0.0;
}


float calcRadian(vec2 p1, vec2 p2) {

    return atan((p1.y - p2.y), (p1.x - p2.x));
}
vec2 stretchUvX(vec2 uv, float value, vec2 lt, vec2 rt, vec2 rb, vec2 lb,
vec2 leftContral, vec2 rightContral, vec2 topContral, vec2 bottomContral,
float adjustPercent, float adjustStartXPercent, float adjustEndXPercent){
    if (!isPointInRectangle(uv, lt, rt, rb, lb)){
        gl_FragColor=texture2D(inputImageTexture, uv);
        return uv;
    }

    bool divideByTB = checkPointIsLeft(topContral, bottomContral, uv);
    float mRadian = calcRadian(topContral, bottomContral);
    float adjustSize = min(adjustStartXPercent, (1.0 - adjustEndXPercent));

    float dx = 1.0;
    float dy =  1.0; ;

    float currentDistence2CenterTopBottom = pointDistanceToLine(uv, topContral, bottomContral);
    float currentDistence2CenterLeftRight = pointDistanceToLine(uv, leftContral, rightContral);

    float percentX = 1.0;
    float percentY = 1.0;
    //中线垂点,区间中线交点 ，边缘交点
    float  maxDis2LR;
    float  maxDis2TB;

    bool isDivideByLR = checkPointIsLeft(rightContral, leftContral, uv);
    if (isDivideByLR){
        maxDis2LR =  pointDistanceToLine(lt, leftContral, rightContral);
    } else {
        maxDis2LR =  pointDistanceToLine(lb, leftContral, rightContral);
    }

    percentY = 1.0 - currentDistence2CenterLeftRight /maxDis2LR;

    if (divideByTB){
        maxDis2TB =  pointDistanceToLine(lt, topContral, bottomContral);
    } else {
        maxDis2TB =  pointDistanceToLine(rt, topContral, bottomContral);
    }
    float maxAdjustPercent = value* adjustSize * adjustPercent * maxDis2TB;
    dx =  -sin(mRadian)* maxAdjustPercent;
    dy =  cos(mRadian)* maxAdjustPercent;


    float adjustStartX = adjustStartXPercent * maxDis2TB;
    float adjustEnd = adjustEndXPercent * maxDis2TB;
    ////
    if (currentDistence2CenterTopBottom > adjustEnd - maxAdjustPercent){
        float adjustWidth  = maxDis2TB - adjustEnd  + maxAdjustPercent;
        percentX = (maxDis2TB - currentDistence2CenterTopBottom)/adjustWidth;

        gl_FragColor = vec4(percentX, 0.0, 0.0, 1.0);
    } else if (currentDistence2CenterTopBottom > adjustStartX - maxAdjustPercent){
        //        percentX = 1.0f;
        gl_FragColor = vec4(0.0, percentX, 0.0, 1.0);
    } else {
        float adjustWidth  =adjustStartX - maxAdjustPercent;
        percentX =  currentDistence2CenterTopBottom/adjustWidth;
        gl_FragColor = vec4(0.0, 0.0, percentX, 1.0);
    }

    if (divideByTB){
        uv = vec2(uv.x- dx *percentX*percentY, uv.y-dy *percentX*percentY);
//                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(0.2, 0.0, 0.0, 1.0);
//        gl_FragColor = vec4(percentX, 0.0, 0.0, 1.0);
    } else {
        uv = vec2(uv.x +  dx*percentX * percentY, uv.y +dy *percentX*percentY);
//                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(0.0, 0.2, 0.0, 1.0);
//        gl_FragColor = vec4( 0.0, percentX,0.0, 1.0);
    }
//    gl_FragColor = vec4( 0.0, percentY,0.0, 1.0);
    //    gl_FragColor=texture2D(inputImageTexture, uv) * 0.8  + 0.2 * vec4(1.0,0.0,0.0,1.0);

    return uv;
}

void main()
{
    vec2 uv = textureCoordinate;

    if (isPointInRectangle(uv, mEdgePoint[0], mEdgePoint[1], mEdgePoint[2], mEdgePoint[3])){
        vec2  leftContral = (mEdgePoint[0]+ mEdgePoint[3])/2.0;
        vec2  rightContral = (mEdgePoint[1]+ mEdgePoint[2])/2.0;
        vec2  topContral = (mEdgePoint[0]+ mEdgePoint[1])/2.0;
        vec2  bottomContral = (mEdgePoint[2]+ mEdgePoint[3])/2.0;
        uv = stretchUvX(uv, intensity, mEdgePoint[0], mEdgePoint[1], mEdgePoint[2], mEdgePoint[3],
        leftContral, rightContral, topContral, bottomContral, 0.3, 0.5, 0.5);

        //        uv = translateUV(uv,intensity);
//                gl_FragColor=vec4(1.0,0.0,0.0,1.0);
        gl_FragColor=texture2D(inputImageTexture, uv);
    } else {
        gl_FragColor=texture2D(inputImageTexture, uv);
    }


}