////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform bool isHorizontal;
uniform float start;
uniform float end;
uniform float scale;

void main()
{
    vec2 position=textureCoordinate;
    float lengthScale=1.+(end-start)*(scale-1.);

    float p=0.;
    if (isHorizontal){
        p=position.y;
    } else {
        p=position.x;
    }

    if (p<(start/lengthScale)){
        p=p*lengthScale;
    } else if (p>1.-(1.-end)/lengthScale){
        p=1.-(1.-p)*lengthScale;
    } else {
        p=p*lengthScale/scale+start*(1.-1./scale);
    }

    if (isHorizontal){
        position.y=p;
    } else {
        position.x=p;
    }

    gl_FragColor=texture2D(inputImageTexture, position);
}