////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform float mEdgePoint[10];
uniform float intensity;

float pointDistanceToLine(vec2 p, vec2 a, vec2 b) {
    vec2 ap = p - a;
    vec2 ab = b - a;
    float ab2 = dot(ab, ab);
    float ap_ab = dot(ap, ab);
    float t = ap_ab / ab2;
    vec2 c = a + t * ab;
    return length(p - c);
}

bool isPointInRectangle(vec2 p, vec2 a, vec2 b, vec2 c, vec2 d) {
    // Vector cross product to check if the point is on the correct side of each edge
    vec2 ab = b - a;
    vec2 ap = p - a;
    vec2 bc = c - b;
    vec2 bp = p - b;
    vec2 cd = d - c;
    vec2 cp = p - c;
    vec2 da = a - d;
    vec2 dp = p - d;

    float cross1 = ab.x * ap.y - ab.y * ap.x;
    float cross2 = bc.x * bp.y - bc.y * bp.x;
    float cross3 = cd.x * cp.y - cd.y * cp.x;
    float cross4 = da.x * dp.y - da.y * dp.x;
    return (cross1 >= 0.0 && cross2 >= 0.0 && cross3 >= 0.0 && cross4 >= 0.0);
}

bool  checkPointIsLeft(vec2 line1, vec2 line2, vec2 checkPoint) {
    // Calculate the cross product
    float crossProduct = (line2.x - line1.x) * (checkPoint.y - line1.y) - (line2.y -line1.y) * (checkPoint.x - line1.x);
    return crossProduct > 0.0;
}


vec2 translateUV(vec2 uv, float translate){
    vec2 centerTop = vec2((mEdgePoint[0] + mEdgePoint[2])/ 2.0 , (mEdgePoint[1] +mEdgePoint[3])/2.0);
    vec2 centerBottom = vec2((mEdgePoint[4] + mEdgePoint[6])/ 2.0 , (mEdgePoint[5] +mEdgePoint[7])/2.0);
    vec2 centerLeft = vec2((mEdgePoint[0] + mEdgePoint[6])/ 2.0 , (mEdgePoint[1] +mEdgePoint[7])/2.0);
    vec2 centerRight = vec2((mEdgePoint[2] + mEdgePoint[4])/ 2.0 , (mEdgePoint[3] +mEdgePoint[5])/2.0);

    bool isLeft = checkPointIsLeft(centerTop, centerBottom, uv);
    float mRadian = 0.0;
    float dx = -translate * cos(mRadian);
    float dy = translate * sin(mRadian);

    float currentDistence2CenterV =pointDistanceToLine(uv, centerTop, centerBottom);
    float currentDistence2CenterH =pointDistanceToLine(uv, centerLeft, centerRight);
    float outPoint2CenterHorizontalHalf = pointDistanceToLine(vec2(mEdgePoint[0], mEdgePoint[1]), centerTop, centerBottom)/2.0;
    float outPoint2CenterVertical = pointDistanceToLine(vec2(mEdgePoint[0], mEdgePoint[1]), centerLeft, centerRight);

    float percentX = 1.0;
    float percentY = 1.0;
    if(isLeft){
        if(currentDistence2CenterV < outPoint2CenterHorizontalHalf - dx ){
            percentX = (currentDistence2CenterV)/ (outPoint2CenterHorizontalHalf - dx);
        }else{
            percentX = 1.0 - (currentDistence2CenterV-(outPoint2CenterHorizontalHalf - dx))/ (outPoint2CenterHorizontalHalf + dx);
        }
    }else{
        if(currentDistence2CenterV < outPoint2CenterHorizontalHalf - dx){
            percentX = - (currentDistence2CenterV)/ (outPoint2CenterHorizontalHalf - dx);
        }else{
            percentX = 1.0 - (currentDistence2CenterV-(outPoint2CenterHorizontalHalf - dx))/ (outPoint2CenterHorizontalHalf + dx);
            percentX = - percentX;
        }
    }
    percentY = 1.0- currentDistence2CenterH /outPoint2CenterVertical;
    uv = vec2(uv.x- dx * percentX * percentY, uv.y+ dy *percentX*percentY);
    return uv;
}


void main()
{
    vec2 uv = textureCoordinate;
    if (isPointInRectangle(uv, vec2(mEdgePoint[0], mEdgePoint[1]), vec2(mEdgePoint[2], mEdgePoint[3]),
           vec2(mEdgePoint[4], mEdgePoint[5]), vec2(mEdgePoint[6], mEdgePoint[7]))){
        uv = translateUV(uv,intensity);
        gl_FragColor = texture2D(inputImageTexture, uv) ;
    }else{
        gl_FragColor=texture2D(inputImageTexture, uv);
    }



}