////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;

uniform vec2 inputSize;
uniform vec2 centerPoint;
uniform float radius;
uniform float scale;

void main()
{
    vec2 position=textureCoordinate;
    vec2 realPosition=vec2(position.x*inputSize.x, position.y*inputSize.y);
    vec2 realCenter=vec2(centerPoint.x*inputSize.x, centerPoint.y*inputSize.y);
    float realRadius=radius*inputSize.x;
    float dis=distance(realPosition, realCenter);
    vec2 originalPosition=realPosition;
    if (dis<=realRadius && dis != 0.) {
        float ratio=dis/realRadius;
        float realScale = scale - (scale - 1.) * ratio;
        originalPosition.x = (realPosition.x - realCenter.x) / dis * (dis / realScale) + realCenter.x;
        originalPosition.y = (realPosition.y - realCenter.y) / dis * (dis / realScale) + realCenter.y;
    }
    position.x = originalPosition.x / inputSize.x;
    position.y = originalPosition.y / inputSize.y;
    gl_FragColor=texture2D(inputImageTexture, position);
}