////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform vec2 inputSize;
uniform float mAutoHead;//小头 Head
uniform float mAutoWaist;//瘦腰
uniform float mAutoWHR;//沙漏腰
uniform float mAutoBelly;//瘦肚子
uniform float mAutoLength;//长腿

uniform float mAutoLegs;//瘦腿
uniform float mAutoBreasts;//丰胸
uniform float mAutoHips;//丰臀
uniform float mAutoHipsLift;//提臀
uniform float mAutoArms;//手臂

uniform float mAutoBroad;//肩宽
uniform float mAutoSquare;//直角肩
uniform float mAutoNeck;//天鹅颈
uniform float mAutoThickness;//脖子
uniform vec2 bodyPoints[73];


vec2 getIntersection(vec2 p1, vec2 p2, vec2 p0) {
    if (p1.x == p2.x){
        return vec2(p1.x, p0.y);
    }
    float m = (p2.y - p1.y) / (p2.x - p1.x);
    float c = p1.y - m * p1.x;

    // Calculate the intersection point (ix, iy)
    float ix = (p0.x + m * (p0.y - c)) / (1.0 + m * m);
    float iy = m * ix + c;

    return vec2(ix, iy);
}

vec2 getCrossPoint(vec2 A, vec2 B, vec2 C, vec2 D){
    float m1 = (B.y - A.y) / (B.x - A.x);
    float c1 = A.y - m1 * A.x;

    float m2 = (D.y - C.y) / (D.x - C.x);
    float c2 = C.y - m2 * C.x;

    // 初始化交点
    vec2 intersection = vec2(0.0, 0.0);

    // 如果斜率不相等，计算交点
    if (m1 != m2) {
        intersection.x = (c2 - c1) / (m1 - m2);
        intersection.y = m1 * intersection.x + c1;
    }
    return intersection;
}



bool isPointInRectangle(vec2 p, vec2 a, vec2 b, vec2 c, vec2 d) {
    // Vector cross product to check if the point is on the correct side of each edge
    vec2 ab = b - a;
    vec2 ap = p - a;
    vec2 bc = c - b;
    vec2 bp = p - b;
    vec2 cd = d - c;
    vec2 cp = p - c;
    vec2 da = a - d;
    vec2 dp = p - d;

    float cross1 = ab.x * ap.y - ab.y * ap.x;
    float cross2 = bc.x * bp.y - bc.y * bp.x;
    float cross3 = cd.x * cp.y - cd.y * cp.x;
    float cross4 = da.x * dp.y - da.y * dp.x;
    return (cross1 >= 0.0 && cross2 >= 0.0 && cross3 >= 0.0 && cross4 >= 0.0);
}
float calcRadian(vec2 p1, vec2 p2) {
    //    vec2 direction = p2 - p1;
    //    return atan(direction.y, direction.x);  // 返回弧度值
    return atan((p1.y - p2.y), (p1.x - p2.x));
}
//// 计算点到线段的距离函数
float pointDistanceToLine(vec2 p, vec2 a, vec2 b) {
    vec2 ap = p - a;
    vec2 ab = b - a;
    float ab2 = dot(ab, ab);
    float ap_ab = dot(ap, ab);
    float t = ap_ab / ab2;
    vec2 c = a + t * ab;
    return length(p - c);
}

bool  checkPointIsLeft(vec2 line1, vec2 line2, vec2 checkPoint) {
    // Calculate the cross product
    float crossProduct = (line2.x - line1.x) * (checkPoint.y - line1.y) - (line2.y -line1.y) * (checkPoint.x - line1.x);

    return crossProduct > 0.0;
}

vec2 translateWidthUv(vec2 uv, float value, vec2 lt, vec2 rt, vec2 rb, vec2 lb,
vec2 leftContral, vec2 rightContral, vec2 topContral, vec2 bottomContral,
float adjustPercent, float adjustStartXPercent, float adjustEndXPercent){

    if (!isPointInRectangle(uv, lt, rt, rb, lb)){
        gl_FragColor=texture2D(inputImageTexture, uv);
        return uv;
    }
    bool isLeft = checkPointIsLeft(topContral, bottomContral, uv);

    float mRadian = calcRadian(topContral, bottomContral);
    float adjustSize = min(adjustStartXPercent, (1.0 - adjustEndXPercent));


    float maxAdjustPercent = adjustSize * adjustPercent;
    float dx = -value  * maxAdjustPercent  * sin(mRadian);
    float dy = value  * maxAdjustPercent  * cos(mRadian);

    float currentDistence2CenterY = pointDistanceToLine(uv, topContral, bottomContral);
    float currentDistence2CenterX = pointDistanceToLine(uv, leftContral, rightContral);


    float percentX = 1.0;
    float percentY = 1.0;
    //中线垂点,区间中线交点 ，边缘交点
    vec2  intersectionPointWithY = getIntersection(topContral, bottomContral, uv);
    vec2  intersectionPointWithX = getIntersection(leftContral, rightContral, uv);
    vec2 crossPointHalfLine, crossPointOutLine;
    float crossPoint2CenterX, crossPointHalf2CenterY, crossPoint2CenterY;

    bool isTop = checkPointIsLeft(rightContral, leftContral, uv);
    if (isTop){
        crossPointOutLine =  getCrossPoint(lt, rt, intersectionPointWithX, uv);
    } else {
        crossPointOutLine =  getCrossPoint(lb, rb, intersectionPointWithX, uv);
    }
    crossPoint2CenterX = pointDistanceToLine(crossPointOutLine, leftContral, rightContral);
    percentY = 1.0 - currentDistence2CenterX/crossPoint2CenterX;

//            if (isTop){
//                gl_FragColor =vec4(abs(sin(mRadian)), 0.0, 0.0, 1.0);
//            } else {
//                gl_FragColor =vec4(0.0, 0.0, abs(cos(mRadian)), 1.0);
//            }

    float maxDis ;
    if (isLeft){
        crossPointOutLine =  getCrossPoint(lt, lb, intersectionPointWithY, uv);
        float ltDis = pointDistanceToLine(lt, topContral, bottomContral);
        float lbDis = pointDistanceToLine(lb, topContral, bottomContral);
        maxDis = max(ltDis,lbDis);
    } else {
        crossPointOutLine =  getCrossPoint(rt, rb, intersectionPointWithY, uv);
        float rtDis = pointDistanceToLine(rt, topContral, bottomContral);
        float rbDis = pointDistanceToLine(rb, topContral, bottomContral);
        maxDis = max(rtDis,rbDis);
    }
    crossPoint2CenterY  = pointDistanceToLine(crossPointOutLine, topContral, bottomContral);
    dx = crossPoint2CenterY * dx;
    dy = crossPoint2CenterY  *dy;

//    dx = maxDis * dx;
//    dy = maxDis  *dy;
//    crossPoint2CenterY  = pointDistanceToLine(crossPointOutLine, topContral, bottomContral);
    float adjustStartX = adjustStartXPercent * crossPoint2CenterY;
    float adjustEnd = adjustEndXPercent * crossPoint2CenterY;

    if (currentDistence2CenterY > adjustEnd - dx){
        float adjustWidth  = crossPoint2CenterY - adjustEnd  + dx;
        percentX = (crossPoint2CenterY - currentDistence2CenterY)/adjustWidth;
        //                        gl_FragColor =vec4(percentX, 0.0, 0.0, 1.0);
                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(percentX, 0.0, 0.0, 1.0) * 0.2;
    } else if (currentDistence2CenterY > adjustStartX - dx){
        percentX = 1.0f;
        //                        gl_FragColor =vec4(0.0, percentX, 0.0, 1.0);
                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4( 0.0, percentX,0.0, 1.0) * 0.2;
    } else {
        float adjustWidth  =adjustStartX - dx;
        percentX =  currentDistence2CenterY/adjustWidth;
                                gl_FragColor =vec4(0.0, 0.0, percentX, 1.0);
                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4( 0.0, 0.0,percentX, 1.0) * 0.5;
    }

    if (isLeft){
        uv = vec2(uv.x- dx *percentX*percentY, uv.y- dy *percentX*percentY);
    } else {
        uv = vec2(uv.x+ dx *percentX*percentY, uv.y+ dy *percentX*percentY);
    }

    //    percentX = isLeft ? -percentX : percentX;

        gl_FragColor = texture2D(inputImageTexture, uv) * 0.9 + vec4(0.1, 0.0, 0.0, 1.0);
//    gl_FragColor = texture2D(inputImageTexture, uv);
    //        gl_FragColor = vec4(0.0,0.0,percentX*percentY,1.0);
    return uv;
}

void  initEdge(vec2 lt, vec2 rt, vec2 rb, vec2 lb, float distanceOffset, float leftOffset, float rightOffset, out vec2 edgePoints[4]){
    float topDistance = distance(lt, rt)*distanceOffset;
    vec2 dir = normalize(rt - lt);// 计算单位方向向量
    vec2 reslutLt = clamp(lt - dir * topDistance * leftOffset, 0.0, 1.0);// A 向反方向延伸
    vec2  reslutRt = clamp(rt + dir * topDistance *rightOffset, 0.0, 1.0);// B 向前方向延伸
    float bottomDistance = distance(lb, rb)*distanceOffset;
    dir = normalize(rb - lb);
    vec2  resultRb = clamp(rb + dir * bottomDistance *rightOffset, 0.0, 1.0);
    vec2 resultLb = clamp(lb - dir * bottomDistance *leftOffset, 0.0, 1.0);
    edgePoints[0] = reslutLt;
    edgePoints[1] = reslutRt;
    edgePoints[2] = resultRb;
    edgePoints[3] = resultLb;
}

void  initEdge2(vec2 lt, vec2 rt, vec2 rb, vec2 lb, float distanceOffset, float leftOffset, float rightOffset, out vec2 edgePoints[4]){
    vec2  intersectionPointWithY = getIntersection(lt, lb,rt );
    lt = intersectionPointWithY;
    float topDistance = distance(lt, rt)*distanceOffset;
    vec2 dir = normalize(rt - lt);// 计算单位方向向量
    vec2 reslutLt = clamp(lt - dir * topDistance * leftOffset, 0.0, 1.0);// A 向反方向延伸
    vec2  reslutRt = clamp(rt + dir * topDistance *rightOffset, 0.0, 1.0);// B 向前方向延伸

    vec2 resultLb = clamp(lb , 0.0, 1.0);
    vec2  resultRb = clamp(resultLb + dir * distance(reslutLt, reslutRt) , 0.0, 1.0);
//    float bottomDistance = distance(lb, rb)*distanceOffset;
//    dir = normalize(rb - lb);
//    vec2  resultRb = clamp(rb + dir * distance(lt, rt) *rightOffset, 0.0, 1.0);
//    vec2 resultLb = clamp(lb , 0.0, 1.0);
    edgePoints[0] = reslutLt;
    edgePoints[1] = reslutRt;
    edgePoints[2] = resultRb;
    edgePoints[3] = resultLb;
}

vec2 translateWaistUV(vec2 uv, float value){
    vec2 edgePoints[4];
    initEdge(bodyPoints[15], bodyPoints[47], bodyPoints[42], bodyPoints[20], 0.2, 1.0, 1.0, edgePoints);
    vec2  leftContral = (edgePoints[0]+ edgePoints[3])/2.0;
    vec2  rightContral = (edgePoints[1]+ edgePoints[2])/2.0;
    vec2  topContral = (edgePoints[0]+ edgePoints[1])/2.0;
    vec2  bottomContral = (edgePoints[2]+ edgePoints[3])/2.0;
    return translateWidthUv(uv, value, edgePoints[0], edgePoints[1], edgePoints[2], edgePoints[3],
    leftContral, rightContral, topContral, bottomContral, 0.4, 0.7, 0.7);
}

vec2 translateWHRUV(vec2 uv, float value){
    vec2 edgePoints[4];
    initEdge(bodyPoints[16], bodyPoints[46], bodyPoints[43], bodyPoints[19], 0.2, 1.0, 1.0, edgePoints);
    vec2  topContral = (edgePoints[0]+ edgePoints[1])/2.0;
    vec2  bottomContral = (edgePoints[2]+ edgePoints[3])/2.0;
    return translateWidthUv(uv, value, edgePoints[0], edgePoints[1], edgePoints[2], edgePoints[3],
    bodyPoints[17], bodyPoints[45], topContral, bottomContral, 0.4, 0.7, 0.7);
}

vec2 translateLegsUV(vec2 uv, float value){

    //20 31  22 29 24 27
    vec2 leftTopEdgePoints[4],leftBottomEdgePoint[4],rightTopEdgePoints[4],rightBottomEdgePoint[4];
    initEdge(bodyPoints[20], bodyPoints[31], bodyPoints[29], bodyPoints[22], 0.2, 1.0, 0.0, leftTopEdgePoints);
    initEdge(bodyPoints[22], bodyPoints[29], bodyPoints[27], bodyPoints[24], 0.2, 1.0, 0.0, leftBottomEdgePoint);
    initEdge2(bodyPoints[31], bodyPoints[42], bodyPoints[40], bodyPoints[33], 0.2, 0.0, 1.0, rightTopEdgePoints);
    initEdge(bodyPoints[33], bodyPoints[40], bodyPoints[38], bodyPoints[35], 0.2, 0.0, 1.0, rightBottomEdgePoint);
    if (isPointInRectangle(uv, leftTopEdgePoints[0], leftTopEdgePoints[1], leftTopEdgePoints[2], leftTopEdgePoints[3])){
        uv =  translateWidthUv(uv, value, leftTopEdgePoints[0], leftTopEdgePoints[1], leftTopEdgePoints[2], leftTopEdgePoints[3],
         leftTopEdgePoints[3], leftTopEdgePoints[2], leftTopEdgePoints[1], leftTopEdgePoints[2], 0.4, 0.3, 0.8);
//    }else if(isPointInRectangle(uv, leftBottomEdgePoint[0], leftBottomEdgePoint[1], leftBottomEdgePoint[2], leftBottomEdgePoint[3])){
//        uv =  translateWidthUv(uv, value, leftBottomEdgePoint[0], leftBottomEdgePoint[1], leftBottomEdgePoint[2], leftBottomEdgePoint[3],
//        leftBottomEdgePoint[0], leftBottomEdgePoint[1], leftBottomEdgePoint[1], leftBottomEdgePoint[2], 0.4, 0.3, 0.8);
    }else if(isPointInRectangle(uv, rightTopEdgePoints[0], rightTopEdgePoints[1], rightTopEdgePoints[2], rightTopEdgePoints[3])){

        uv =  translateWidthUv(uv, value, rightTopEdgePoints[0], rightTopEdgePoints[1], rightTopEdgePoints[2], rightTopEdgePoints[3],
        rightTopEdgePoints[3], rightTopEdgePoints[2], rightTopEdgePoints[0], rightTopEdgePoints[3], 0.4, 0.5, 0.8);
//    }else if(isPointInRectangle(uv, rightBottomEdgePoint[0], rightBottomEdgePoint[1], rightBottomEdgePoint[2], rightBottomEdgePoint[3])){
//        uv =  translateWidthUv(uv, value, rightBottomEdgePoint[0], rightBottomEdgePoint[1], rightBottomEdgePoint[2], rightBottomEdgePoint[3],
//        rightBottomEdgePoint[0], rightBottomEdgePoint[1], rightBottomEdgePoint[0], rightBottomEdgePoint[3], 0.4, 0.3, 0.8);
    }else {
        gl_FragColor = texture2D(inputImageTexture, uv);
    }


    return uv;
}

void main()
{
    vec2 uv=textureCoordinate;
    if(abs(mAutoWaist) > 0.01){
        uv = translateWaistUV(uv, mAutoWaist);
    }else {
        gl_FragColor = texture2D(inputImageTexture, uv);
    }
//    if(abs(mAutoWHR) > 0.01){
//        uv = translateWHRUV(uv, mAutoWHR);
//    }
//    if(abs(mAutoLegs) > 0.01){
//        uv = translateLegsUV(uv, mAutoLegs);
//    }else {
//        gl_FragColor = texture2D(inputImageTexture, uv);
//    }
//    if(abs(mAutoWaist) > 0.01){
//        uv = translateWaistUV(uv, mAutoWaist);
//    }
//
    //

//        uv = translateLegsUV(uv, mAutoLegs);
//        uv = translateWHRUV(uv, mAutoWHR);
//        gl_FragColor = texture2D(inputImageTexture, uv);
}