////// Fragment Shader
precision highp float;

varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform vec2 inputSize;
uniform float mAutoHead;//小头 Head
uniform float mAutoWaist;//瘦腰
uniform float mAutoWHR;//沙漏腰

uniform float mAutoBreastsLift;
uniform float mAutoLegs;//瘦腿
uniform float mAutoHips;//丰臀
uniform float mAutoHipsLift;//提臀
uniform float mAutoArms;//手臂

uniform float mAutoBroad;//肩宽
uniform float mAutoSquare;//直角肩
uniform float mAutoNeck;//天鹅颈
uniform float mAutoThickness;//脖子
uniform float mAutoThicknessHeight;//脖子

uniform vec2 mHeadEdgeArray[5];
uniform vec2 mWaistEdgeArray[10];
uniform vec2 mWHREdgeArray[10];
uniform vec2 mBreastLiftArray[20];
uniform vec2 mBroadArray[20];
uniform vec2 mHipArray[10];
uniform vec2 mLegsArray[40];
uniform vec2 mArmsArray[40];
uniform vec2 mThickArray[20];
uniform vec2 mNeckArray[20];
const float threshold = 0.005;
uniform  float ratio;
uniform int mArmValidArray[4];
uniform int mLegValidArray[4];





bool isPointInRectangle(vec2 p, vec2 a, vec2 b, vec2 c, vec2 d) {
    // Vector cross product to check if the point is on the correct side of each edge
    vec2 ab = b - a;
    vec2 ap = p - a;
    vec2 bc = c - b;
    vec2 bp = p - b;
    vec2 cd = d - c;
    vec2 cp = p - c;
    vec2 da = a - d;
    vec2 dp = p - d;

    float cross1 = ab.x * ap.y - ab.y * ap.x;
    float cross2 = bc.x * bp.y - bc.y * bp.x;
    float cross3 = cd.x * cp.y - cd.y * cp.x;
    float cross4 = da.x * dp.y - da.y * dp.x;
    return (cross1 >= 0.0 && cross2 >= 0.0 && cross3 >= 0.0 && cross4 >= 0.0);
}

//// 计算点到线段的距离函数
float pointDistanceToLine(vec2 p, vec2 a, vec2 b) {
    vec2 ap = p - a;
    vec2 ab = b - a;
    float ab2 = dot(ab, ab);
    float ap_ab = dot(ap, ab);
    float t = ap_ab / ab2;
    vec2 c = a + t * ab;
    return length(p - c);
}

bool  checkPointIsLeft(vec2 line1, vec2 line2, vec2 checkPoint) {
    // Calculate the cross product
    float crossProduct = (line2.x - line1.x) * (checkPoint.y - line1.y) - (line2.y -line1.y) * (checkPoint.x - line1.x);
    return crossProduct > 0.0;
}


vec2 stretchUvX(vec2 uv, float value, vec2 lt, vec2 rt, vec2 rb, vec2 lb, vec2 leftContral, vec2 rightContral, vec2 topContral, vec2 bottomContral,
float mRadian, float adjustPercent, float adjustStartXPercent, float adjustEndXPercent, float adjustXPercent){
    if (!isPointInRectangle(uv, lt, rt, rb, lb)){

        return uv;
    }
    bool divideByTB = checkPointIsLeft(topContral, bottomContral, uv);
    float adjustSize = min(adjustStartXPercent, (1.0 - adjustEndXPercent));
    float dx = 1.0;
    float dy =  1.0; ;

    float currentDistence2CenterTopBottom = pointDistanceToLine(uv, topContral, bottomContral);
    float currentDistence2CenterLeftRight = pointDistanceToLine(uv, leftContral, rightContral);

    float percentX = 1.0;
    float percentY = 1.0;
    //中线垂点,区间中线交点 ，边缘交点
    float  maxDis2LR;
    float  maxDis2TB;

    bool isDivideByLR = checkPointIsLeft(rightContral, leftContral, uv);
    if (isDivideByLR){
        maxDis2LR =  pointDistanceToLine(lt, leftContral, rightContral);
    } else {
        maxDis2LR =  pointDistanceToLine(lb, leftContral, rightContral);
    }

    if (currentDistence2CenterLeftRight > maxDis2LR * adjustXPercent){
        percentY = 1.0 -(currentDistence2CenterLeftRight - maxDis2LR * adjustXPercent) /(maxDis2LR -maxDis2LR* adjustXPercent);
    }

    if (divideByTB){
        maxDis2TB =  pointDistanceToLine(lt, topContral, bottomContral);
    } else {
        maxDis2TB =  pointDistanceToLine(rt, topContral, bottomContral);
    }
    float maxAdjustPercent = value* adjustSize * adjustPercent * maxDis2TB;
    dx =  -sin(mRadian)* maxAdjustPercent;
    dy =  cos(mRadian)* maxAdjustPercent;


    float adjustStartX = adjustStartXPercent * maxDis2TB;
    float adjustEnd = adjustEndXPercent * maxDis2TB;
    ////
    if (currentDistence2CenterTopBottom > adjustEnd - maxAdjustPercent){
        float adjustWidth  = maxDis2TB - adjustEnd  + maxAdjustPercent;
        percentX = (maxDis2TB - currentDistence2CenterTopBottom)/adjustWidth;
    } else if (currentDistence2CenterTopBottom > adjustStartX - maxAdjustPercent){

    } else {
        float adjustWidth  =adjustStartX - maxAdjustPercent;
        percentX =  currentDistence2CenterTopBottom/adjustWidth;

    }

    if (divideByTB){
        uv = vec2(uv.x- dx *percentX*percentY, uv.y-dy *percentX*percentY);
//                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(0.2, 0.0, 0.0, 1.0);

    } else {
        uv = vec2(uv.x +  dx*percentX * percentY, uv.y +dy *percentX*percentY);
//                gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(0.0, 0.2, 0.0, 1.0);
    }
//    gl_FragColor = texture2D(inputImageTexture, uv) * 0.8 + vec4(0.2, 0.0, 0.0, 1.0);
    return uv;
}



vec2 translateUv(vec2 uv, float value, vec2 lt, vec2 rt, vec2 rb, vec2 lb,
vec2 topContral, vec2 bottomContral, float mRadian, float adjustPercent, float startXPercent, float endXPercent,
float startYPercent, float endYPercent, bool bothSide){
    if (!isPointInRectangle(uv, lt, rt, rb, lb)){
//        gl_FragColor = texture2D(inputImageTexture, uv);
        return uv;
    }

    bool isLeft = checkPointIsLeft(topContral, bottomContral, uv);

    float heightDistance = pointDistanceToLine(lb, lt, rt);
    float topContral2TopDis = startYPercent * heightDistance;
    float bottomContral2TopDis = endYPercent * heightDistance;
    float contral2TopDis = min(topContral2TopDis, bottomContral2TopDis);

    float current2TopDis = pointDistanceToLine(uv, lt, rt);

    float current2BottomDis = pointDistanceToLine(uv, lb, rb);

    float maxAdjustSize = contral2TopDis * value * adjustPercent;
    float dx = maxAdjustSize * cos(mRadian);
    float dy = -maxAdjustSize  * sin(mRadian);
    float percentX = 1.0;
    float percentY = 1.0;

    float currentDistence2CenterY = pointDistanceToLine(uv, topContral, bottomContral);
    float crossPoint2CenterY;
    if (isLeft){
        crossPoint2CenterY  = pointDistanceToLine(lt, topContral, bottomContral);
    } else {
        crossPoint2CenterY  = pointDistanceToLine(rt, topContral, bottomContral);
    }


    float adjustStartX = startXPercent * crossPoint2CenterY;
    float adjustEndX = endXPercent * crossPoint2CenterY;
    if (bothSide){
        if (currentDistence2CenterY > adjustStartX){
            percentX =  1.0 - (currentDistence2CenterY - adjustStartX) / (crossPoint2CenterY- adjustStartX);
        }
    } else {
        if (currentDistence2CenterY > adjustEndX){
            percentX =  1.0 - (currentDistence2CenterY - adjustEndX) / (crossPoint2CenterY- adjustEndX);

        } else if (currentDistence2CenterY < adjustStartX){
            percentX =  currentDistence2CenterY  / adjustStartX;

        }else {

        }

    }
    if (current2TopDis < topContral2TopDis - maxAdjustSize){
        float adjustHeight = topContral2TopDis - maxAdjustSize;
        percentY = current2TopDis/adjustHeight;
    } else if (current2TopDis < bottomContral2TopDis - maxAdjustSize){
    } else {
        float adjustHeight = heightDistance - bottomContral2TopDis + maxAdjustSize;
        percentY = 1.0- (current2TopDis - bottomContral2TopDis +  maxAdjustSize) /adjustHeight;
    }
    if (isLeft){
        uv = vec2(uv.x - dx *percentX * percentY, uv.y+dy *percentX *percentY);
//        gl_FragColor = texture2D(inputImageTexture, uv) * 0.9 + vec4(1.0, 0.0, 0.0, 1.0) * 0.1;
    } else {
        uv = vec2(uv.x -  dx*percentX * percentY, uv.y +dy *percentX*percentY);
//        gl_FragColor = texture2D(inputImageTexture, uv) * 0.9 + vec4( 0.0,1.0, 0.0, 1.0) * 0.1;
    }
//            gl_FragColor = texture2D(inputImageTexture, uv) * 0.9 + vec4(0.0, 1.0, 0.0, 1.0) * 0.1;

    return uv;
}

vec2 zoomUv(vec2 uv, float value, float radius, vec2 centerPoint){
    float scale = value/10.0 +1.0;
    vec2 dir = uv - centerPoint;
    dir.x *= ratio;
    float dist = length(dir);
    vec2 firstOffset;
    if (dist < radius) {
        float t = (radius - dist) / radius;
        float scaleFactor = mix(1.0, scale, t);
        dir *= scaleFactor;
        dir.x /= ratio;
        uv = centerPoint + dir;
    }
    return uv;
}

void  initEdge(vec2 lt, vec2 rt, vec2 rb, vec2 lb, float distanceOffset,
float leftOffset, float rightOffset, out vec2 edgePoints[4]){
    float topDistance = distance(lt, rt)*distanceOffset;
    vec2 dir = normalize(rt - lt);// 计算单位方向向量
    vec2 reslutLt = clamp(lt - dir * topDistance * leftOffset, 0.0, 1.0);
    vec2  reslutRt = clamp(rt + dir * topDistance *rightOffset, 0.0, 1.0);
    float bottomDistance = distance(lb, rb)*distanceOffset;
    dir = normalize(rb - lb);
    vec2  resultRb = clamp(rb + dir * bottomDistance *rightOffset, 0.0, 1.0);
    vec2 resultLb = clamp(lb - dir * bottomDistance *leftOffset, 0.0, 1.0);
    edgePoints[0] = reslutLt;
    edgePoints[1] = reslutRt;
    edgePoints[2] = resultRb;
    edgePoints[3] = resultLb;
}


vec2 translatNeckWidthUV(vec2 uv, float value){
    uv = stretchUvX(uv, value, mThickArray[0], mThickArray[1], mThickArray[2], mThickArray[3],
    mThickArray[4], mThickArray[5], mThickArray[1], mThickArray[2], mThickArray[8].x, 0.3, 0.375, 0.375, 0.0);


    uv = stretchUvX(uv, value, mThickArray[10], mThickArray[11], mThickArray[12], mThickArray[13],
    mThickArray[14], mThickArray[15], mThickArray[10], mThickArray[13], mThickArray[8].x, 0.3, 0.375, 0.375, 0.0);
    return uv;
}

vec2 translateWaistUV(vec2 uv, float value){
    uv = stretchUvX(uv, value, mWaistEdgeArray[0], mWaistEdgeArray[1], mWaistEdgeArray[2], mWaistEdgeArray[3],
    mWaistEdgeArray[4], mWaistEdgeArray[5], mWaistEdgeArray[6], mWaistEdgeArray[7], mWaistEdgeArray[8].x,
    0.2, 0.4, 0.6, 0.0);
    return uv;
}

vec2 translateWHRUV(vec2 uv, float value){
    uv = stretchUvX(uv, value, mWHREdgeArray[0], mWHREdgeArray[1], mWHREdgeArray[2], mWHREdgeArray[3],
    mWHREdgeArray[4], mWHREdgeArray[5], mWHREdgeArray[6], mWHREdgeArray[7], mWHREdgeArray[8].x,
    0.2, 0.4, 0.6, 0.0);
    return uv;
}

vec2 translatHipsUV(vec2 uv, float value){
    uv = stretchUvX(uv, -value, mHipArray[0], mHipArray[1], mHipArray[2], mHipArray[3],
    mHipArray[4], mHipArray[5], mHipArray[6], mHipArray[7], mHipArray[8].x, 0.10, 0.5, 0.5, 0.5);
    return uv;
}

vec2 translatHipsLiftUV(vec2 uv, float value){
    uv = translateUv(uv, value, mHipArray[0], mHipArray[1], mHipArray[2], mHipArray[3],
    mHipArray[6], mHipArray[7], mHipArray[8].x, 0.3, 0.5, 0.7, 0.3, 0.3, true);
    return uv;
}

vec2 translatNeckHeightUV(vec2 uv, float value){
    vec2  topContral = (mHeadEdgeArray[0]+ mHeadEdgeArray[1])/2.0;
    vec2  bottomContral = (mHeadEdgeArray[2]+ mHeadEdgeArray[3])/2.0;
    uv = translateUv(uv, value, mHeadEdgeArray[0], mHeadEdgeArray[1], mHeadEdgeArray[2], mHeadEdgeArray[3],
    topContral, bottomContral, mHeadEdgeArray[4].x, 0.1, 0.18, 0.82, 0.18, 0.82, true);
    return uv;
}

vec2 translatNeckUV(vec2 uv, float value){
    uv = stretchUvX(uv, value, mNeckArray[0], mNeckArray[1], mNeckArray[2], mNeckArray[3],
    mNeckArray[4], mNeckArray[5], mNeckArray[1], mNeckArray[2], mNeckArray[8].x, 0.12, 0.5, 0.5, 0.5);
    uv = translateUv(uv, -value, mNeckArray[0], mNeckArray[1], mNeckArray[2], mNeckArray[3],
    mNeckArray[1], mNeckArray[2], mNeckArray[8].x, 0.2, 0.1, 0.5, 0.3, 0.3, false);

    uv = stretchUvX(uv, value, mNeckArray[10], mNeckArray[11], mNeckArray[12], mNeckArray[13],
    mNeckArray[14], mNeckArray[15], mNeckArray[10], mNeckArray[13], mNeckArray[18].x, 0.12, 0.5, 0.5, 0.5);
    uv = translateUv(uv, -value, mNeckArray[10], mNeckArray[11], mNeckArray[12], mNeckArray[13],
    mNeckArray[10], mNeckArray[13], mNeckArray[18].x, 0.2, 0.1, 0.5, 0.3, 0.3, false);
    return uv;
}


vec2 translateBreastsLiftUV(vec2 uv, float value){
    uv = translateUv(uv, value, mBreastLiftArray[0], mBreastLiftArray[1], mBreastLiftArray[2], mBreastLiftArray[3],
    mBreastLiftArray[6], mBreastLiftArray[7], mBreastLiftArray[8].x, 0.3, 0.5, 0.5, 0.4, 0.8, true);

    uv = translateUv(uv, value, mBreastLiftArray[10], mBreastLiftArray[11], mBreastLiftArray[12], mBreastLiftArray[13],
    mBreastLiftArray[16], mBreastLiftArray[17], mBreastLiftArray[18].x, 0.3, 0.5, 0.5, 0.4, 0.8, true);
    return uv;
}

vec2 translatBroadUV(vec2 uv, float value){
    uv = stretchUvX(uv, -value, mBroadArray[0], mBroadArray[1], mBroadArray[2], mBroadArray[3],
    mBroadArray[4], mBroadArray[5], mBroadArray[1], mBroadArray[2], mBroadArray[8].x, 0.2, 0.2, 0.8, 0.5);

    uv = stretchUvX(uv, -value, mBroadArray[10], mBroadArray[11], mBroadArray[12], mBroadArray[13],
    mBroadArray[14], mBroadArray[15], mBroadArray[10], mBroadArray[13], mBroadArray[18].x, 0.2, 0.2, 0.8, 0.5);
    return uv;
}

vec2 translatSquareUV(vec2 uv, float value){
    uv = translateUv(uv, value, mBroadArray[0], mBroadArray[1], mBroadArray[2], mBroadArray[3],
    mBroadArray[1], mBroadArray[2], mBroadArray[8].x, 0.3, 0.2, 0.2, 0.2, 0.8, false);

    uv = translateUv(uv, value, mBroadArray[10], mBroadArray[11], mBroadArray[12], mBroadArray[13],
    mBroadArray[10], mBroadArray[13], mBroadArray[18].x, 0.3, 0.2, 0.2, 0.2, 0.8, false);
    return uv;
}

vec2 translateArmsUV(vec2 uv, float value){
    if (mArmValidArray[0] == 0){
        uv = stretchUvX(uv, value, mArmsArray[0], mArmsArray[1], mArmsArray[2], mArmsArray[3],
        mArmsArray[4], mArmsArray[5], mArmsArray[6], mArmsArray[7], mArmsArray[8].x, 0.15, 0.4, 0.6, 0.5);

    }
    if (mArmValidArray[1] == 0){
        uv = stretchUvX(uv, value, mArmsArray[10], mArmsArray[11], mArmsArray[12], mArmsArray[13],
        mArmsArray[14], mArmsArray[15], mArmsArray[16], mArmsArray[17], mArmsArray[18].x, 0.12, 0.4, 0.6, 0.5);

    }
    if (mArmValidArray[2] == 0){
        uv = stretchUvX(uv, value, mArmsArray[20], mArmsArray[21], mArmsArray[22], mArmsArray[23],
        mArmsArray[24], mArmsArray[25], mArmsArray[26], mArmsArray[27], mArmsArray[28].x, 0.15, 0.4, 0.6, 0.5);

    }
    if (mArmValidArray[3] == 0){
        uv = stretchUvX(uv, value, mArmsArray[30], mArmsArray[31], mArmsArray[32], mArmsArray[33],
        mArmsArray[34], mArmsArray[35], mArmsArray[36], mArmsArray[37], mArmsArray[38].x, 0.12, 0.4, 0.6, 0.5);

    }

    return uv;
}

vec2 translateLegsUV(vec2 uv, float value){
    if (mLegValidArray[0] == 0){
        uv = stretchUvX(uv, value, mLegsArray[0], mLegsArray[1], mLegsArray[2], mLegsArray[3],
        mLegsArray[4], mLegsArray[5], mLegsArray[6], mLegsArray[7], mLegsArray[8].x, 0.2, 0.5, 0.5, 0.65);
    }
    if (mLegValidArray[1] == 0){
        uv = stretchUvX(uv, value, mLegsArray[10], mLegsArray[11], mLegsArray[12], mLegsArray[13],
        mLegsArray[14], mLegsArray[15], mLegsArray[16], mLegsArray[17], mLegsArray[18].x, 0.2, 0.5, 0.5, 0.65);
    }
    if (mLegValidArray[2] == 0){
        uv = stretchUvX(uv, value, mLegsArray[20], mLegsArray[21], mLegsArray[22], mLegsArray[23],
        mLegsArray[24], mLegsArray[25], mLegsArray[26], mLegsArray[27], mLegsArray[28].x, 0.2, 0.5, 0.5, 0.65);
    }
    if (mLegValidArray[3] == 0){
        uv = stretchUvX(uv, value, mLegsArray[30], mLegsArray[31], mLegsArray[32], mLegsArray[33],
        mLegsArray[34], mLegsArray[35], mLegsArray[36], mLegsArray[37], mLegsArray[38].x, 0.2, 0.5, 0.5, 0.65);
    }
    return uv;
}


vec2 zoomHeadUv(vec2 uv, float value){
    vec2 centerTop = (mHeadEdgeArray[0] + mHeadEdgeArray[1])/2.0;
    vec2 centerBottom = (mHeadEdgeArray[2] + mHeadEdgeArray[3])/2.0;
    vec2 centerPoint = (centerTop + centerBottom)/2.0;
    float radius = distance(centerTop, centerPoint);
    return zoomUv(uv, value, radius, centerPoint);
}

void main()
{
    vec2 uv=textureCoordinate;
    if (abs(mAutoHead) > threshold){
        uv = zoomHeadUv(uv, mAutoHead);
    }

    if (abs(mAutoWaist) > threshold){
        uv = translateWaistUV(uv, mAutoWaist);
    }
    if (abs(mAutoWHR) > threshold){
        uv = translateWHRUV(uv, mAutoWHR);
    }
    if (abs(mAutoBreastsLift) > threshold){
        uv = translateBreastsLiftUV(uv, mAutoBreastsLift);
    }

    if (abs(mAutoHips) > threshold){
        uv = translatHipsUV(uv, mAutoHips);
    }
    if (abs(mAutoHipsLift) > threshold){
        uv = translatHipsLiftUV(uv, mAutoHipsLift);
    }

    if (abs(mAutoLegs) > threshold){
        uv = translateLegsUV(uv, mAutoLegs);
    }

    if (abs(mAutoArms) > threshold){
        uv = translateArmsUV(uv, mAutoArms);
    }

    if (abs(mAutoBroad) > threshold){
        uv = translatBroadUV(uv, mAutoBroad);
    }

    if (abs(mAutoSquare) > threshold){
        uv = translatSquareUV(uv, mAutoSquare);
    }

    if (abs(mAutoNeck) > threshold){
        uv = translatNeckUV(uv, mAutoNeck);
    }

    if (abs(mAutoThickness) > threshold){
        uv = translatNeckWidthUV(uv, mAutoThickness);

    }
    if (abs(mAutoThicknessHeight) > threshold){
        uv = translatNeckHeightUV(uv, mAutoThicknessHeight);
    }

    gl_FragColor = texture2D(inputImageTexture, uv);

}