////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
// 滤镜纹理
uniform sampler2D filterTexture;
// 融合矩阵
uniform mat4 mBlendMatrix;

uniform int frontBackType;
uniform float intensity;

uniform float lowerThreshold;
uniform float higherThreshold;

const mediump vec3 luminanceWeighting = vec3(0.2126, 0.7152, 0.0722);


vec4 lookup(vec4 textureColor, sampler2D filter, float intensity) {
    highp float blueColor = textureColor.b * 63.0;

    highp vec2 quad1;
    quad1.y = floor(floor(blueColor) / 8.0);
    quad1.x = floor(blueColor) - (quad1.y * 8.0);

    highp vec2 quad2;
    quad2.y = floor(ceil(blueColor) / 8.0);
    quad2.x = ceil(blueColor) - (quad2.y * 8.0);

    highp vec2 texPos1;
    texPos1.x = (quad1.x * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * textureColor.r);
    texPos1.y = (quad1.y * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * textureColor.g);

    highp vec2 texPos2;
    texPos2.x = (quad2.x * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * textureColor.r);
    texPos2.y = (quad2.y * 0.125) + 0.5 / 512.0 + ((0.125 - 1.0 / 512.0) * textureColor.g);

    lowp vec4 newColor1 = texture2D(filter, texPos1);
    lowp vec4 newColor2 = texture2D(filter, texPos2);

    lowp vec4 newColor = mix(newColor1, newColor2, fract(blueColor));


    vec3 resultRBG = mix(textureColor.rgb, newColor.rgb, intensity);
    return vec4(resultRBG * textureColor.a, textureColor.a);
}

void main() {
    vec4 srcColor = texture2D(inputImageTexture, textureCoordinate);
    vec4 fliterResult = lookup(srcColor, filterTexture, intensity);
    vec4 resultColor = fliterResult;

    // 与融合图融合
    vec4 coordinate = vec4(textureCoordinate, 0., 1.);
    coordinate = mBlendMatrix * coordinate;
    if (coordinate.x >= 0.0 && coordinate.x <= 1.0 && coordinate.y >= 0.0 && coordinate.y <= 1.0) {
        vec4 blendresult = texture2D(inputImageTexture2, coordinate.xy);
        // 计算颜色的亮度
        float luminance = dot(fliterResult.rgb, luminanceWeighting);
        float strength = 0.0;
        if (luminance < lowerThreshold) {
            strength = 0.0;
        } else if (luminance >= lowerThreshold && luminance <= higherThreshold) {
            strength = smoothstep(lowerThreshold, higherThreshold, luminance);
        } else if (luminance > higherThreshold) {
            strength = 1.0;
        }
        // Add 混合
        vec3 result = fliterResult.rgb + blendresult.rgb * strength;
        // 限制亮度不超过 1.0
        result = min(result, vec3(1.0));
        resultColor = vec4(result, fliterResult.a);
    }

    if (frontBackType != 0) {
        vec4 maskColor = texture2D(inputImageTexture3, textureCoordinate);
        gl_FragColor = mix(resultColor, srcColor, maskColor.a);
    } else {
        gl_FragColor = resultColor;
    }
}