////// Fragment Shader
precision highp float;
varying highp vec2 textureCoordinate;
varying highp vec2 textureCoordinate2;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform float intensity;
uniform vec2 inputSize;


float calcRadian(vec2 p1, vec2 p2) {
    return atan((p1.y - p2.y)/(p1.x - p2.x));
}

void main()
{

    highp vec4 baseColor = texture2D(inputImageTexture, textureCoordinate);
    float maxDis;

    if(inputSize.x > inputSize.y){
        maxDis = length(vec2(0.5,0.0) - 0.5);
    }else{
        maxDis = length(vec2(0.0,0.5) - 0.5);
    }
   float currentDis =  length(textureCoordinate - vec2(0.5,0.5));

    if(currentDis > maxDis){
        gl_FragColor = baseColor;
    }else{
        float offset = 1.0 -currentDis / maxDis;
        vec3 result= vec3(0);
        float mag = intensity * 1.045 * baseColor.a *offset;
        float exppower = 1.0 + abs(mag);
        result.r = 1.0 - pow((1.0 - baseColor.r), exppower);
        result.g = 1.0 - pow((1.0 - baseColor.g), exppower);
        result.b = 1.0 - pow((1.0 - baseColor.b), exppower);
        // 输出最终颜色
        gl_FragColor = vec4(result, baseColor.a);
    }
}