////// Fragment Shader
precision highp float;
//            uniform  vec2 inputSize;
varying highp vec2 textureCoordinate;
uniform sampler2D inputImageTexture;
uniform highp float clarity;
uniform highp float denoising;

 vec3 W = vec3(0.298,0.588,0.113);

vec3 rgb2hsv(vec3 c){
     vec4 K = vec4(0.0, -1.0 / 3.0, 2.0 / 3.0, -1.0);
     vec4 p = c.g < c.b ? vec4(c.bg, K.wz) : vec4(c.gb, K.xy);
     vec4 q = c.r < p.x ? vec4(p.xyw, c.r) : vec4(c.r, p.yzx);
     float d = q.x - min(q.w, q.y);
     float e = 1.0e-10;
     return vec3(abs(q.z + (q.w - q.y) / (6.0 * d + e)), d / (q.x + e), q.x);
}

 vec3 hsv2rgb(vec3 c){
    vec4 K = vec4(1.0, 2.0 / 3.0, 1.0 / 3.0, 3.0);
    vec3 p = abs(fract(c.xxx + K.xyz) * 6.0 - K.www);
    return c.z * mix(K.xxx, clamp(p - K.xxx, 0.0, 1.0), c.y);
 }

void  main() {

    vec4 src = texture2D(inputImageTexture, textureCoordinate);
    if (src.a ==0.0){
        gl_FragColor =  vec4(0);
        return;
    }
    float dClarity = clarity -denoising;
    float srcHum = dot(src.rgb, W);
    float avgerLum = srcHum;
    float weight = 1.0;
    //               float limit = dClarity > 0.0 ? 8.0 : 6.0;

    vec2 inputSize2 = vec2(300, 300);
    for (float t=1.; t<3.0; t++){
        float distance =t;
        float left = dot(texture2D(inputImageTexture, textureCoordinate +vec2(-distance/inputSize2.x, 0)).rgb, W);
        float right = dot(texture2D(inputImageTexture, textureCoordinate +vec2(distance/inputSize2.x, 0)).rgb, W);
        float top = dot(texture2D(inputImageTexture, textureCoordinate +vec2(0, -distance/inputSize2.y)).rgb, W);
        float bottom = dot(texture2D(inputImageTexture, textureCoordinate +vec2(0, distance/inputSize2.y)).rgb, W);

        float leftWeight  =  1.0 - abs(left - srcHum);
        float rightWeight =  1.0 - abs(right - srcHum);
        float topWeight   =  1.0 - abs(top - srcHum);
        float bottomWeight = 1.0 - abs(bottom - srcHum);



        avgerLum = avgerLum + leftWeight * left + rightWeight *right + top * topWeight + bottom *bottomWeight;

        weight = weight +  leftWeight + rightWeight  + topWeight + bottomWeight;

    }

    avgerLum = avgerLum/weight;
    vec3 srcHsv = rgb2hsv(src.rgb);


    float resultClarity;
    float  dLum =srcHum - avgerLum;
    if (dClarity > 0.0){
        float  dx =dLum > 0.0 ? 20.0 :15.0;
        gl_FragColor =vec4(src.rgb + src.rgb*(dClarity/dx *dLum), src.a);
    } else {
        resultClarity = dClarity/34.56;
        srcHsv.z   = clamp(srcHsv.z *(1.0+ dLum * resultClarity *(1.2-srcHsv.z)), 0.0, 1.0);

        gl_FragColor = vec4(hsv2rgb(srcHsv), src.a);
    }
}