#version 300 es
precision highp float;
in highp vec2 textureCoordinate;
in highp vec2 textureCoordinate2;
in highp vec2 textureCoordinate3;
in highp vec2 textureCoordinate4;

uniform sampler2D inputImageTexture;
uniform sampler2D inputImageTexture2;
uniform sampler2D inputImageTexture3;
uniform sampler2D inputImageTexture4;

uniform float w1;
uniform float w2;
uniform float w3;
uniform float intensity;
uniform vec2 size;
out vec4 FragColor;

void main()
{
    float dimension = 33.0;

    vec4 color = texture(inputImageTexture, textureCoordinate.xy);
    vec3 dim = ((color.rgb * (dimension - 1.0) + 0.5))/dimension;

    float startX = floor(dim.g * dimension)/dimension;
    float endX = startX+1.0;

    float x = dim.r/dimension + startX;
    float y = dim.b;
    vec2 coor = vec2(x, y);

    vec4 destColor2 = texture(inputImageTexture2, coor);
    vec4 destColor3 = texture(inputImageTexture3, coor);
    vec4 destColor4 = texture(inputImageTexture4, coor);

    vec4 destColor = vec4(1.0);
    destColor.rgb = destColor2.rgb*w1 + destColor3.rgb*w2 + destColor4.rgb*w3;

    //coor = vec2((textureCoordinate.x)/dimension, textureCoordinate.y);
    //vec4 col = texture(inputImageTexture2, coor);

    FragColor = vec4(mix(color.rgb, destColor.rgb, intensity), color.a);
}