import 'package:flutter/material.dart';

enum SupportedLanguages { en_US, en_GB, fr }

class Localization {
  late SupportedLanguages _language;

  Localization({required String locale}) {
    if (locale == "en_US") {
      this._language = SupportedLanguages.en_US;
    } else if (locale == "en_GB" || locale == "en_IE") {
      this._language = SupportedLanguages.en_GB;
    } else if (locale.toString().contains("fr")) {
      this._language = SupportedLanguages.fr;
    } else {
      this._language = SupportedLanguages.en_US;
    }
  }

  Localization.fromLocale(Locale locale) {
    if (locale.toString() == "en_US") {
      this._language = SupportedLanguages.en_US;
    } else if (locale.toString() == "en_GB" || locale.toString() == "en_IE") {
      this._language = SupportedLanguages.en_GB;
    } else if (locale.toString().contains("fr")) {
      this._language = SupportedLanguages.fr;
    } else {
      this._language = SupportedLanguages.en_US;
    }
  }

  set language(SupportedLanguages language) {
    this._language = language;
  }

  SupportedLanguages get language => _language;
}

extension Getters on SupportedLanguages {
  String get tooltipPath {
    switch (this) {
      case SupportedLanguages.en_US:
        return "assets/json/tooltips_en.json";
      case SupportedLanguages.en_GB:
        return "assets/json/tooltips_en_GB.json";
      case SupportedLanguages.fr:
        return "assets/json/tooltips_fr.json";
    }
  }

  String get assetPathPrefix {
    switch (this) {
      case SupportedLanguages.fr:
        return "fr/";
      default:
        return "";
    }
  }

  Locale get locale {
    switch (this) {
      case SupportedLanguages.en_US:
        return Locale('en', 'US');
      case SupportedLanguages.en_GB:
        return Locale('en', 'GB');
      case SupportedLanguages.fr:
        return Locale('fr');
    }
  }
}
