XMLHttpRequest.prototype.origOpen = XMLHttpRequest.prototype.open;
XMLHttpRequest.prototype.open = function(method, url, async, user, password) {
    // these will be the key to retrieve the payload
    this.recordedMethod = method;
    this.recordedUrl = url;
    this.origOpen(method, url, async, user, password);

    // Intercept response from WebView and send in to JavaScript Kotlin interface.
    // Will filter it there
    this.onreadystatechange = function() {
        if (this.readyState == 4 && this.status == 200) {
            recorder.recordResponse(this.recordedMethod, this.recordedUrl, this.responseText);
        }
    };
};
XMLHttpRequest.prototype.origSend = XMLHttpRequest.prototype.send;
XMLHttpRequest.prototype.send = function(body) {
    // interceptor is a Kotlin interface added in WebView
    if(body) recorder.recordPayload(this.recordedMethod, this.recordedUrl, body);
    this.origSend(body);
};
