let replacements = {}

const trigonometry = {
  mode: 'deg'
}

const fns1 = ['sin', 'cos', 'tan', 'sec', 'cot', 'csc']
fns1.forEach(function(name) {
  const fn = math[name]
  const fnNumber = function (x) {
    if (trigonometry.mode == 'deg') {
      if (name == 'sin') {
        if (x % 180 == 0) return 0;
      }
      if (name == 'cos') {
        if (x % 360 == 0) return 1;
        if (x % 180 == 0) return -1;
        if (x % 90 == 0) return 0;
      }
      if (name == 'tan') {
        if (x % 180 == 0) return 0;
        if (x % 90 == 0) return 1 / 0;
      }
      return fn(x / 360 * 2 * Math.PI);
    } else {
      if (name == 'sin') {
        if (x % Math.PI == 0) return 0;
      }
      if (name == 'tan') {
        if (x % Math.PI == 0) return 0;
      }
      return fn(x);
    }
  }
  replacements[name] = math.typed(name, {
    'number': fnNumber,
    'Array | Matrix': function (x) {
      return math.map(x, fnNumber)
    }
  })
})

const fns2 = ['asin', 'acos', 'atan', 'atan2', 'acot', 'acsc', 'asec']
fns2.forEach(function(name) {
  const fn = math[name]
  const fnNumber = function (x) {
    const result = fn(x)
    if (typeof result === 'number') {
      if (trigonometry.mode == 'deg') {
        return result / 2 / Math.PI * 360;
      } else {
        return result;
      }
    }
    return result
  }
  replacements[name] = math.typed(name, {
    'number': fnNumber,
    'Array | Matrix': function (x) {
      return math.map(x, fnNumber)
    }
  })
})

math.import(replacements, {override: true})