precision mediump float;
uniform sampler2D uSampler;
uniform sampler2D uSampler2;
varying vec2 vCoordinate;
uniform float uProgress;
void main() {

    float uOffset = uProgress;

    vec2 newCoordinate = vec2(vCoordinate.x, vCoordinate.y - uOffset);

    if (vCoordinate.y > uOffset) {
        gl_FragColor = texture2D(uSampler, newCoordinate);
    } else {
        if (uOffset > 1.0) {
            vec2 newCoordinate2 = vec2(vCoordinate.x, vCoordinate.y);
            gl_FragColor = texture2D(uSampler2, newCoordinate2);
        } else {
            float drawOffset = 1.0 - uOffset;
            vec2 newCoordinate2 = vec2(vCoordinate.x, vCoordinate.y + drawOffset);
            gl_FragColor = texture2D(uSampler2, newCoordinate2);
        }

    }
}