precision mediump float;
varying highp vec2 vCoordinate;
uniform float duration;
uniform sampler2D uSampler;
uniform sampler2D uSampler2;
uniform lowp float uProgress;
#define iTime uProgress
    #define fragColor gl_FragColor
    #define fragCoord vCoordinate
    #define iChannel0 uSampler
    #define iChannel1 uSampler2
    #define texture texture2D
    vec4 rule(vec2 coord)
{
    vec2 uv2 = coord - vec2(0.5, 0.5);
    float angle = atan(uv2.y, uv2.x);
    float c = angle / 2.0 / 3.1416 + 0.5;
    return vec4(c, c, c, 1);
}
void main()
{
    vec2 uv = fragCoord;
    vec4 src = texture(iChannel0, uv);
    vec4 dst = texture(iChannel1, uv);
    vec4 white = vec4(1.0);
    float rule = rule(uv).g;
    float vague = 0.1;
    float delay = 0.;
    float phase = uProgress * (1.0 + vague + delay);
    float p0 = smoothstep(rule, rule + vague, phase);
    float p1 = smoothstep(rule + delay, rule + vague + delay, phase);
    fragColor = src * (1.0 - p0) + white * (p0 - p1) + dst * p1;
}