precision highp float;
varying vec2 vCoordinate;
uniform float uProgress;
uniform float ratio;
uniform sampler2D uSampler;
uniform sampler2D uSampler2;
float cross2d(vec2 a, vec2 b)
{
    return sqrt((a.x - b.x) * (a.x - b.x) + (a.y - b.y) * (a.y - b.y));
}
void main()
{
    highp float radius = uProgress * sqrt(1.0 + ratio * ratio) / 2.0;
    vec2 coord = vec2((vCoordinate.x - 0.5) * ratio + 0.5, vCoordinate.y);
    highp float distance = cross2d(coord, vec2(0.5, 0.5));
    highp float mixValue = (distance - (radius - 0.001)) / (0.001 + 0.001);
    mixValue = min(mixValue, 1.);
    mixValue = max(mixValue, 0.);
    gl_FragColor = mix(texture2D(uSampler, vCoordinate), texture2D(uSampler2, vCoordinate), 1. - mixValue);
}