precision highp float;
varying highp vec2 vCoordinate;
uniform sampler2D uSampler;
uniform sampler2D uSampler2;
uniform lowp float uProgress;
#define fragColor gl_FragColor
    #define fragCoord vCoordinate
    #define iChannel0 uSampler
    #define iChannel1 uSampler2
    #define texture texture2D
 const float strength = 1.0;
const float PI = 3.141592653589793;
float Linear_ease(in float begin, in float change, in float duration, in float time) {
    return change * time / duration + begin;
}
float Exponential_easeInOut(in float begin, in float change, in float duration, in float time) {
    if (time == 0.0)
    return begin;
    else if (time == duration)
    return begin + change;
    time = time / (duration / 2.0);
    if (time < 1.0)
    return change / 2.0 * pow(2.0, 10.0 * (time - 1.0)) + begin;
    return change / 2.0 * (-pow(2.0, -10.0 * (time - 1.0)) + 2.0) + begin;
}
float Sinusoidal_easeInOut(in float begin, in float change, in float duration, in float time) {
    return -change / 2.0 * (cos(PI * time / duration) - 1.0) + begin;
}
float random(in vec3 scale, in float seed) {
    return fract(sin(dot(gl_FragCoord.xyz + seed, scale)) * 43758.5453 + seed);
}
vec3 crossFade(in vec2 uv, in float dissolve) {
    return mix(texture(uSampler, uv).rgb, texture(uSampler2, uv).rgb, dissolve);
}
void main() {
    vec2 texCoord = fragCoord.xy;
    float uProgress2 = uProgress;
    vec2 center = vec2(Linear_ease(0.5, 0.0, 1.0, uProgress2), 0.5);
    float dissolve = Exponential_easeInOut(0.0, 1.0, 1.0, uProgress2);
    float strength = Sinusoidal_easeInOut(0.0, strength, 0.5, uProgress2);
    vec3 color = vec3(0.0);
    float total = 0.0;
    vec2 toCenter = center - texCoord;
/*randomize the lookup values to hide the fixed number of samples*/
    float offset = random(vec3(12.9898, 78.233, 151.7182), 0.0) * 0.5;
    for (float t = 0.0; t <= 20.0; t++) {
        float percent = (t + offset) / 20.0;
        float weight = 1.0 * (percent - percent * percent);
        color += crossFade(texCoord + toCenter * percent * strength, dissolve) * weight;
        total += weight;
    }
    fragColor = vec4(color / total, 1.0);
}