#extension GL_OES_EGL_image_external: require
precision mediump float;
uniform samplerExternalOES uSampler;
varying vec2 vCoordinate;
uniform float isVert;
uniform vec4 imageRect;
uniform vec4 drawRectF;
uniform float inAngle;//角度
uniform float isFlipped;
uniform vec2 center;// 相对于中心点旋转

float dashSize = 0.008;//虚线大小
float stepInterval = 8.0;//虚线间隔


// 旋转矩阵函数
mat2 rotationMatrix(float angle) {
    float cosAngle = cos(angle);
    float sinAngle = sin(angle);
    return mat2(cosAngle, sinAngle, -sinAngle, cosAngle);
}
//处理旋转
vec2 uvRotate(vec2 baseUv, float angle, vec2 center) {
    vec2 uv = baseUv;
    // 计算相对于中心点的纹理坐标偏移
    uv -= center;
    // 计算旋转后的纹理坐标
    float cosAngle = cos(angle);
    float sinAngle = sin(angle);
    mat2 m = rotationMatrix(angle);
    // 根据角度进行缩放纠正
    uv = m * uv;
    // 计算旋转后的纹理坐标
    uv += center;
    return uv;
}

// 添加函数来判断是否在虚线边框上
float isDashedBorder(float targetValue, float dashSize) {
    float modResult = mod(targetValue, dashSize * stepInterval);
    return step(dashSize, modResult);
}

//绘制外部的虚线框，可展示区域
bool drawLineRect(vec2 drawXyRect) {

    //获取imagexyRect的宽高比
    float imagexyRectRatio = (imageRect.b - imageRect.r) / (imageRect.a - imageRect.g);
    imagexyRectRatio = 1.0;
    if (imagexyRectRatio < 1.0) {
        //根据imagexyRect的宽高比调整虚线大小
        //保证虚线大小不变
        dashSize = dashSize / imagexyRectRatio;
    }
    float horizontalDashSize = dashSize * imagexyRectRatio;

    bool veritcal = drawXyRect.x < dashSize || drawXyRect.x > (1.0 - dashSize);
    bool horizontal = drawXyRect.y < horizontalDashSize || drawXyRect.y > (1.0 - horizontalDashSize);
    // 判断是否超出边界
    bool isOutside2 = drawXyRect.x < 0.0 ||
    drawXyRect.x > 1.0 ||
    drawXyRect.y < 0.0 ||
    drawXyRect.y > 1.0;

    if (isOutside2) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        return true;
    }
    if (veritcal) {
        //竖线
        float result = isDashedBorder(drawXyRect.y, horizontalDashSize);
        if (result > 0.0) {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
            return true;
        }
    } else if (horizontal) {
        //横线
        float result = isDashedBorder(drawXyRect.x, dashSize);
        if (result > 0.0) {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
            return true;
        }
    }
    return false;
}
const vec3 GRAY = vec3(0.299, 0.587, 0.144);

void main() {

    // 计算纹理坐标在旋转后的位置
    vec2 drawXyRect = vec2((vCoordinate.x - drawRectF.r) / (drawRectF.b - drawRectF.r),
                           (vCoordinate.y - drawRectF.g) / (drawRectF.a - drawRectF.g));
    vec2 newCoordinate = uvRotate(vCoordinate, -radians(inAngle), center);
    //    vec2 newCoordinate = uvRotate(vCoordinate, -inAngle, center);

    // 计算纹理坐标在旋转后的位置
    vec2 imagexyRect = vec2((newCoordinate.x - imageRect.r) / (imageRect.b - imageRect.r),
                            (newCoordinate.y - imageRect.g) / (imageRect.a - imageRect.g));

    //isFlipped 0:不翻转 1:水平翻转 2:垂直翻转 3:水平垂直翻转
    if (isFlipped == 1.0) {
        imagexyRect.x = 1.0 - imagexyRect.x;
    }

    // 判断是否超出边界
    bool isOutside = imagexyRect.x < 0.0 ||
    imagexyRect.x > 1.0 ||
    imagexyRect.y < 0.0 ||
    imagexyRect.y > 1.0;

    if (drawLineRect(drawXyRect)) {
        return;
    }
    // 在虚线边框上或者超出边界时透明，否则取纹理颜色
    if (isOutside) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    } else {
        vec4 stickerColor = texture2D(uSampler, imagexyRect);
        gl_FragColor = stickerColor;
    }
}
