// 片段着色器
precision mediump float;
uniform sampler2D uSampler;
varying vec2 vCoordinate;
uniform float isVert;
uniform vec4 imageRect;
float dashSize = 0.008;//虚线大小
float stepInterval = 4.0;//虚线间隔

// 添加函数来判断是否在虚线边框上
float isDashedBorder(float targetValue, float dashSize) {
    float modResult = mod(targetValue, dashSize * stepInterval);
    return step(dashSize, modResult);
}

void main() {
    // 计算纹理坐标在旋转后的位置
    vec2 imagexyRect = vec2((vCoordinate.x - imageRect.r) / (imageRect.b - imageRect.r),
                            (vCoordinate.y - imageRect.g) / (imageRect.a - imageRect.g));

    //获取imagexyRect的宽高比
    float imagexyRectRatio = (imageRect.b - imageRect.r) / (imageRect.a - imageRect.g);

    // 判断是否超出边界
    bool isOutside = imagexyRect.x < 0.0 ||
    imagexyRect.x > 1.0 ||
    imagexyRect.y < 0.0 ||
    imagexyRect.y > 1.0;

    // 在虚线边框上或者超出边界时透明，否则取纹理颜色
    if (isOutside) {
        gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
    } else {

        if (imagexyRectRatio < 1.0) {
            //根据imagexyRect的宽高比调整虚线大小
            //保证虚线大小不变
            dashSize = dashSize / imagexyRectRatio;
        }

        float horizontalDashSize = dashSize * imagexyRectRatio;

        bool veritcal = imagexyRect.x < dashSize || imagexyRect.x > (1.0 - dashSize);
        bool horizontal = imagexyRect.y < horizontalDashSize || imagexyRect.y > (1.0 - horizontalDashSize);

        if (veritcal) {
            //竖线
            float result = isDashedBorder(imagexyRect.y, horizontalDashSize);
            if (result > 0.0) {
                gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
                return;
            }
        } else if (horizontal) {
            //横线
            float result = isDashedBorder(imagexyRect.x, dashSize);
            if (result > 0.0) {
                gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
                return;
            }
        }

        // 判断是否超出边界
        bool isOutside2 = imagexyRect.x < 0.0 ||
        imagexyRect.x > 1.0 ||
        imagexyRect.y < 0.0 ||
        imagexyRect.y > 1.0;

        if (isOutside2) {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 1.0);
        } else {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
//            vec4 stickerColor = texture2D(uSampler, imagexyRect);
//            gl_FragColor = stickerColor;
        }
    }
}
