// 顶点着色器
precision mediump float;
attribute vec4 aPos;
attribute vec2 aCoordinate;
varying vec2 vCoordinate;
uniform vec2 uCenter; // 圆心坐标，取值范围 [0, 1]
uniform float uSize; // 圆的半径，取值范围 [0, 1]
uniform float uCrop; // 圆的半径，取值范围 [0, 1]

void main() {
    float scale = 1.0;
    //平移的位置
    vec4 translate;
    //预览模式不变形
    if (uCrop == 0.0) {
        // 缩放系数
        scale = 1.0;
        translate = vec4(0.0, 0.0, 0.0, 0.0);
    } else {
        //视频中心点
        scale = 1.0 / (uSize * 2.0);
        vec2 videCenter = vec2(1.0, 1.0);

        //平移的位置
        translate = vec4(videCenter.x - uCenter.x * 2.0, videCenter.y - uCenter.y * 2.0, 0.0, 0.0);
    }

    // 将原始坐标缩放到一半，并平移到图像中心点
    vec2 scaledPos = (aPos.xy) * scale;

    gl_Position = vec4(scaledPos, aPos.zw) + translate * scale;
    vCoordinate = aCoordinate;
}
