// 片段着色器
precision mediump float;
uniform sampler2D uSampler;
varying vec2 vCoordinate;
uniform vec2 uCenter; // 圆心坐标，取值范围 [0, 1]
uniform float uSize; // 圆的半径，取值范围 [0, 1]
uniform float uCrop; // 圆的半径，取值范围 [0, 1]

void main() {
    //半透明深黑色
    vec2 texCoord = vCoordinate;
    vec2 center = uCenter;
    float radius = uSize;
    // 将纹理坐标映射到以 center 为圆心、半径为 radius 的圆内
    float dist = distance(texCoord, center);
    if (dist > radius) {
        // 圆外部，设置颜色为透明
        //预览模式不变形
        if (uCrop == 0.0) {
            // 圆外部，进行颜色变深变黑处理
            vec4 sourceColor = texture2D(uSampler, texCoord);
            //如果sourceColor是透明的，那么设置半透明
            if (sourceColor.a == 0.0) {
                gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
                return;
            }
            //            vec3 darkenedColor = sourceColor.rgb * 0.3; // 将颜色变暗，这里乘以0.5，你可以根据需要调整
            vec3 darkenedColor = sourceColor.rgb * 1.0; // 将颜色变暗，这里乘以0.5，你可以根据需要调整
            gl_FragColor = vec4(darkenedColor, sourceColor.a);
        } else {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
    } else {
        // 圆内部，保持原始的颜色
        gl_FragColor = texture2D(uSampler, texCoord);
    }
}