// 片段着色器
precision mediump float;
uniform sampler2D uSampler;
varying vec2 vCoordinate;
uniform vec2 uCenter; // 圆心坐标，取值范围 [0, 1]
uniform float uSize; // 圆的半径，取值范围 [0, 1]
uniform float uCrop; // 圆的半径，取值范围 [0, 1]

void main() {
    vec2 texCoord = vCoordinate;
    vec2 center = uCenter;
    float sideLength = uSize * 2.0;

    // 计算正方形内部的范围
    vec2 minRange = center - vec2(sideLength * 0.5, sideLength * 0.5);
    vec2 maxRange = center + vec2(sideLength * 0.5, sideLength * 0.5);

    if (texCoord.x >= minRange.x && texCoord.x <= maxRange.x &&
    texCoord.y >= minRange.y && texCoord.y <= maxRange.y) {
        // 正方形内部，保持原始的颜色
        gl_FragColor = texture2D(uSampler, texCoord);
    } else {
        // 正方形外部，根据 uCrop 进行处理
        if (uCrop == 0.0) {
            vec4 sourceColor = texture2D(uSampler, texCoord);
            if (sourceColor.a == 0.0) {
//                gl_FragColor = vec4(0.0, 0.0, 0.0, 0.3);
                gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
            } else {
                vec3 darkenedColor = sourceColor.rgb * 1.0;
                gl_FragColor = vec4(darkenedColor, sourceColor.a);
            }
        } else {
            gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);
        }
    }
}