precision highp float;
varying highp vec2 vCoordinate;
uniform sampler2D uSampler;
uniform sampler2D uSampler2;
uniform vec4 imageRect;
uniform float index;

void main() {
    //    // 计算纹理坐标在旋转后的位置
    vec2 imagexyRect = vec2((vCoordinate.x - imageRect.r) / (imageRect.b - imageRect.r)
    , (vCoordinate.y - imageRect.g) / (imageRect.a - imageRect.g));
    //
    //    //当前的图像
    vec4 c1 = texture2D(uSampler, vCoordinate);
    //    //贴纸
    vec4 c2 = texture2D(uSampler2, vCoordinate);
    //
    bool isOutside = imagexyRect.x < 0.0 ||
    imagexyRect.x > 1.0 ||
    imagexyRect.y < 0.0 ||
    imagexyRect.y > 1.0;
    lowp vec4 outputColor = c2 + c1 * c1.a * (1.0 - c2.a);
    //    // 判断是否超出边界
    if (isOutside) {
        gl_FragColor = c1;
    } else {
        // 判断两个纹理是否重叠
        if (c1.a > 0.0 && c2.a > 0.0) {
            // 重叠部分的处理
            gl_FragColor = c1;
        } else {
            //            gl_FragColor = vec4(0.0, 0.0, 0.0, 0.0);//透明
            discard;//保留底层的颜色
        }
    }
}



