attribute vec4 aPos;
attribute vec2 aCoordinate;
varying vec2 vCoordinate;
uniform mat4 uStickerMatrix;

uniform float veFlip;
uniform float hoFlip;
uniform float inAngle;
uniform vec2 center;
// 相对于中心点旋转

void main() {
    float centerX = center.x;
    float centerY = center.y;

    //旋转vCoordinate, inAngle度
    //float inAngle = 45.0;
    float radian = radians(-inAngle);
    float cosAngle = cos(radian);
    float sinAngle = sin(radian);
    float x = aCoordinate.x - centerX;
    float y = aCoordinate.y - centerY;
    float x1 = x * cosAngle - y * sinAngle;
    float y1 = x * sinAngle + y * cosAngle;
    vec2 newCoordinate = vec2(x1 + centerX, y1 + centerY);
    vec4 newPos = uStickerMatrix * aPos;

    if (hoFlip == 1.0) {
        // 水平翻转
        newCoordinate.x = centerX - (newCoordinate.x - centerX);
        //赋值
        vCoordinate = newCoordinate;
        gl_Position = newPos;
    }
    if (veFlip == 1.0) {
        // 垂直翻转
        newCoordinate.y = centerY - (newCoordinate.y - centerY);
        //赋值
        vCoordinate = newCoordinate;
        gl_Position = newPos;
    }
    //赋值
    vCoordinate = newCoordinate;
    gl_Position = newPos;
}