precision mediump float;
uniform sampler2D uSampler;
varying vec2 vCoordinate;
uniform float isVert;
uniform vec4 imageRect;
uniform vec4 backgroundColor; // 接收从顶点着色器传递过来的颜色值

void main() {
    // 计算纹理坐标在旋转后的位置
    vec2 imagexyRect = vec2((vCoordinate.x - imageRect.r) / (imageRect.b - imageRect.r)
    , (vCoordinate.y - imageRect.g) / (imageRect.a - imageRect.g));

    bool isOutside = imagexyRect.x < 0.0 ||
    imagexyRect.x > 1.0 ||
    imagexyRect.y < 0.0 ||
    imagexyRect.y > 1.0;
    // 判断是否超出边界
    if (isOutside) {
        //backgroundColor 增加 alpha 透明度
        gl_FragColor = backgroundColor;
    } else {
        vec4 stickerColor = texture2D(uSampler, imagexyRect);
        gl_FragColor = stickerColor;
    }

}

